#!/usr/bin/perl

=head1 

Отправляет в Графит "отствание от продакшена" для тестовых БД.
(Количество дней между снятием бекапа и текущим временем)

Пока годится только для Директа: 
захардкожен префикс метрики, названия конфигураций, конфиг со списками БД и каталогами данных

=cut

use strict;
use warnings;

use Yandex::Advmon;
use YAML;
use Sys::Hostname;
use Pid::File::Flock qw(:auto);

my $conf_file = "/etc/sync-db/direct.conf";

my $fqdn = `hostname -f`;
chomp $fqdn;
my $hostname = hostname();

my $CONFIGURATION = {
    'ppctest-mysql03i.yandex.ru' => 'test',
    'ppctest-mysql01k.yandex.ru' => 'devtest',
    'ppctest-mysql04i.yandex.ru' => 'dev7',
    'ppctest-mysql02k.yandex.ru' => 'test2',
    'ppctest-mysql01e.yandex.ru' => 'loadtest',
}->{$fqdn};

die unless $CONFIGURATION;

my $conf_global = YAML::LoadFile($conf_file);
my $conf = $conf_global->{$hostname} || $conf_global->{DEFAULT};

my $stat = {
};

for my $db ( @{$conf->{databases}} ){
    my $name = (ref $db eq 'HASH') ? $db->{name} : $db;
    my $datadir = (ref $db eq 'HASH') && $db->{datadir} || "/opt/mysql.$name"; 
    my $posfile = `ls -t $datadir/$name-*.pos|head -n 1`;
    chomp $posfile;
    $stat->{$name} = int( -M $posfile);
}

#print STDERR YAML::Dump($stat );
#exit;

local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $CONFIGURATION]};
monitor_values({
        test_db => { days_behind_production => $stat },
});


