#! /usr/bin/perl

=head1 

    Скрипт проверяет имя хоста, и если это тестовая релизная БД -- прверяет стоп-флаг в Табуле.
    Если стоп-флаг не выставлен -- запускает mysql на новых данных, иначе ничего не делает. 

    Для других хостов просто безусловно запускает mysql на новых данных

    Категория аккуратности: "perl вместо /bin/sh"

=cut

use strict;
use warnings;

use Sys::Hostname;
use LWP::UserAgent;
use YAML;
use JSON;

my $project = $ARGV[0];
die "incorrect project name '$project'" unless $project =~ /^[\w-]+$/;

my $hostname = hostname();

my @test_db_hosts = @{YAML::LoadFile("/etc/sync-db/$project.conf")->{DEFAULT}->{"test-db-hosts"} || []};

if ( grep { $_ eq $hostname } @test_db_hosts ){
    my $url = "http://$project-dev.yandex-team.ru/flagman/get?name=stop_update_test_db";
    my $stop_flag = JSON::from_json(LWP::UserAgent->new(timeout => 15)->get($url)->content)->{value};
    if($stop_flag){
        print STDERR "sync-db-start.pl for project $project: exiting because of stop flag\n";
        exit 0;
    }
}

my $exit_code = system "/usr/local/bin/sync-db.pl --start-db --conf /etc/sync-db/$project.conf";
exit $exit_code;

