package TotalMonitor::CocaineApp;

# $Id$

use Mouse;

use Yandex::Shell;
use List::MoreUtils qw/uniq/;
use Sys::Hostname;
use Text::Diff;


has pattern => ( is => 'ro', isa => 'Str', default => q{.*} );


our $COCAINE_MANAGER = $ENV{COCAINE_MANAGER} || "/usr/local/bin/cmgr";
our $FORMAT_VERSION = 2;

our $COCAINE_MAIN_PORT = 10053;



sub get_current_state
{
    my ($self) = @_;

    my $cm_output;
    my @apps;

    my $hostname = hostname();
    # TODO на ТС получать список рантаймов (портов) из cloud-conf-test-status
    my @available_ports = ($COCAINE_MAIN_PORT);
    if ($hostname =~ /ppctest-cloud-front/) {
        push @available_ports, map { $COCAINE_MAIN_PORT + 100 * $_ } (1..10);
    }

    PORT:
    for my $port (@available_ports) {
        my $cm_output_for_port = `$COCAINE_MANAGER list -p $port 2> /dev/null`;

        die "Failed to run $COCAINE_MANAGER for port $port"  if $? || !defined $cm_output_for_port;

        push @apps,
            map { _parse_cm_line($_, $port) }
            grep { my $p = $self->pattern; m/$p/ }
            grep { /^ \w+ \s+ \*/xms } # only promoted apps
            split /\n/, $cm_output_for_port;
        $cm_output //= '';
        $cm_output .= $cm_output_for_port;
    }

    die "Failed to start $COCAINE_MANAGER for all ports" if !defined $cm_output;

    return {
        format_version => $FORMAT_VERSION,
        hostname => $hostname,
        report => $cm_output,
        apps => \@apps,
    };
}


sub _parse_cm_line {
    my ($line, $port) = @_;

    my ($state, $app, $version) = $line =~ /^ (\w+) \s+ \* \s+ (\S+) \s+ (\S+) /xms;
    $app .= "__$port" unless $port == $COCAINE_MAIN_PORT;
    return {
        app => $app,
        version => $version,
        state => $state,
    };
}


sub _get_changes
{
    my ($old_apps, $new_apps) = @_;

    my %old = map {( $_->{app} => $_->{version} )} @$old_apps;
    my %new = map {( $_->{app} => $_->{version} )} @$new_apps;

    my %change;
    for my $app ( uniq sort (keys %old, keys %new) ) {
        next if $old{$app} && $new{$app} && $new{$app} eq $old{$app};
        $change{$app} = [ $old{$app}, $new{$app} ];
    }

    return \%change;
}


sub get_changed_versions
{
    my ($self, $old, $new, $report) = @_;

    $old = { report => q{}, apps => [] }  unless eval { ($old->{format_version} || 0) == $FORMAT_VERSION };

    my $old_apps = $old->{apps};
    # report all versions if hostname changed
    if ( !$old->{hostname} || $new->{hostname} ne $old->{hostname} ) {
        $old_apps = [];
    }

    my $change = _get_changes($old_apps, $new->{apps});
    return if !%$change;

    my @changes = map {[$_, $change->{$_}->[1]]} sort keys %$change;
    return \@changes;
}


sub get_text_diff
{
    my ($self, $old, $new, $report) = @_;

    $old = { report => q{}, apps => [] }  unless eval { ($old->{format_version} || 0) == $FORMAT_VERSION };

    my $diff = diff \$old->{report}, \$new->{report};
    return if !$diff;

    my $change = _get_changes($old->{apps}, $new->{apps});
    my @changes;
    for my $app ( sort keys %$change ) {
        my ($old_version, $new_version) = @{$change->{$app}};
        if (!$old_version) {
            push @changes, "added $app = $new_version";
        }
        elsif (!$new_version) {
            push @changes, "removed $app";
        }
        else {
            push @changes, "updated $app: $old_version -> $new_version";
        }
    }
    return if !@changes;

    my $host = hostname();
    my $msg = join qq{\n\n}, grep { defined && length } (
        "$host: cocaine apps changed:",
        join( qq{\n}, map {"* $_"} @changes ),
        join( qq{\n}, grep {/^[+\-]/} split /\n/, $diff ),
        "Current state:",
        $new->{report}
    );

    return $msg;
}


1;
