#!/usr/bin/perl

=head1 DESCRIPTION

    Компилируем .mo-словари из найденных в locale/ .po-файлов

=cut

use strict;
use warnings;

use File::Copy qw/move/;
use File::Temp qw/tempfile/;
use File::Path;
use File::Slurp;

use Yandex::Shell qw/yash_system yash_qx/;
use Yandex::I18n;
use Yandex::I18nTools;
use Yandex::HashUtils qw/hash_cut/;

use Getopt::Long;

use utf8;
use open ':std' => ':utf8';

my %OPT;
GetOptions(
    'locale_path=s' => \$OPT{locale_path},
    'project_id=s' => \$OPT{project_id},
    'lang=s' => \$OPT{lang},
    'add-locale=s%' => \%Yandex::I18n::LOCALES,
);

# die "locale_path parameter is required" unless $OPT{locale_path};
# die "project_id parameter is required" unless $OPT{project_id};

$Yandex::I18n::LOCALE_PATH = $OPT{locale_path};
$Yandex::I18n::PROJECT_ID = $OPT{project_id};
%Yandex::I18n::LOCALES = %{ hash_cut \%Yandex::I18n::LOCALES, split '\s*,\s*', $OPT{lang}} if ($OPT{lang});

my @langs = grep {-f Yandex::I18nTools::get_po_filename($_)} Yandex::I18n::get_other_langs();
foreach my $lang (@langs) {
    my $locale_dir = $Yandex::I18n::LOCALE_PATH . Yandex::I18n::get_locale($lang) . '/LC_MESSAGES';
    if (!-d $locale_dir) {
        mkpath $locale_dir;
    }
    my $mo_filename  = get_mo_filename($lang);
    my $tmp_filename = $mo_filename.".tmp";
    yash_system('msgfmt', prepare_po_file($lang), '-o', $tmp_filename);
    move($tmp_filename, $mo_filename);
}

exit(0);

sub get_mo_filename
{
    my $lang = shift;
    return $Yandex::I18n::LOCALE_PATH . Yandex::I18n::get_locale($lang) . '/LC_MESSAGES/'.$Yandex::I18n::PROJECT_ID . '.mo';
}

sub prepare_po_file {

    my $lang = shift;
    
    my $orig_po = Yandex::I18nTools::get_po_filename($lang);
    if (my $base = Yandex::I18n::get_base_locale($lang)) {
        my $base_po = Yandex::I18nTools::get_po_filename($base);
        if (-f $base_po) {
            my $merged_msgs = yash_qx('msgcat', '--use-first', '--sort-output', $orig_po, $base_po);
            utf8::decode($merged_msgs) unless utf8::is_utf8($merged_msgs);
            $orig_po = (tempfile(UNLINK => 1))[1]; 
            write_file($orig_po, {atomic => 1, binmode => ':utf8'}, \$merged_msgs);
        }
    }
                
    return $orig_po
}

