#!/usr/bin/perl

=head1 DESCRIPTION

    Собираем шаблоны писем по выгрузке, лежащей в locale/emails.json
    Записываем их в EMAIL_TEMPLATES_FOLDER/$lang/

=cut

use strict;
use warnings;

use Config::General;
use Cwd qw/getcwd/;
use Getopt::Long;
use Yandex::HashUtils qw/hash_cut/;
use Yandex::I18n;
use Yandex::I18nTools;

use utf8;
use open ':std' => ':utf8';


my $BASE_DIR = getcwd();
my %OPT;
GetOptions(
    'base-dir=s' => \$BASE_DIR,
    'config=s' => \$OPT{config},
    'help' => \&usage,
);
my $DEFAULT_CONFIG_LOCATION = "$BASE_DIR/etc/translation.conf";
if (!$OPT{config} && -f $DEFAULT_CONFIG_LOCATION) {
    $OPT{config} = $DEFAULT_CONFIG_LOCATION;
}
die "config file is not defined" unless $OPT{config};
my %conf = Config::General->new($OPT{config})->getall;
$Yandex::I18n::LOCALE_PATH = "$BASE_DIR/$conf{locale_path}";
%Yandex::I18n::LOCALES = %{hash_cut \%Yandex::I18n::LOCALES, split /\s*,\s*/, $conf{lang}} if $conf{lang};
$Yandex::MailTemplate::EMAIL_TEMPLATES_FOLDER = "$BASE_DIR/$conf{email_templates_folder}";
die "$Yandex::MailTemplate::EMAIL_TEMPLATES_FOLDER dir does not exist" unless -d $Yandex::MailTemplate::EMAIL_TEMPLATES_FOLDER;

Yandex::I18nTools::update_emails();
