#!/usr/bin/perl

=head1 DESCRIPTION

    Делаем merge .pot-файла с .po-файлами, обновляя их или создавая, если их не было
    
=cut

use strict;
use warnings;

use File::Slurp;

use Yandex::I18nTools;
use Yandex::HashUtils qw/hash_cut/;

use Getopt::Long;

use utf8;
use open ':std' => ':utf8';


my %OPT;
GetOptions(
    'locale_path=s' => \$OPT{locale_path},
    'project_id=s' => \$OPT{project_id},
    'lang=s' => \$OPT{lang},
    );
$Yandex::I18n::LOCALE_PATH = $OPT{locale_path} if $OPT{locale_path};
$Yandex::I18n::PROJECT_ID = $OPT{project_id} if $OPT{project_id};
%Yandex::I18n::LOCALES = %{ hash_cut \%Yandex::I18n::LOCALES, split '\s*,\s*', $OPT{lang}} if ($OPT{lang});

Yandex::I18nTools::update_po();

exit(0);
