#!/bin/sh -e

# для postinst и prerm: создаем/удаляем пользователя updater

USERLIST="updater"

case "$1" in
    create)
	echo "Checking users list ($USERLIST)..."
	for username in $(echo $USERLIST); do
        id $username > /dev/null 2>&1 || (adduser --firstuid 9050 --gecos "" --quiet --disabled-password --shell /bin/bash $username && echo "No user $username found -- creating.")
	    chown -R "$username":"$username" /home/"$username"
        mkdir -p "/home/$username/.ssh"
        chown -R "$username":"$username" "/home/$username/.ssh"
        chmod 0700 "/home/$username/.ssh"
	done

    # On newer systems (lucid, precise) sudoers.d exists, so it's possible to create sudoers.d/ts-updater file from this script
    echo
    echo
    echo
    echo "Check /etc/sudoers and /etc/sudoers.d/*: $USERLIST need to do sudo /usr/local/bin/ts-update.pl + to run scripts"
    echo 
    echo

    ;;
    remove)
	echo "Removing users ($USERLIST)..."
	for username in $(echo $USERLIST); do
	    deluser $username || echo "User $username wasn't delete."
	done
    ;;

    *)
        echo "unknown argument \`$1'" >&2
        exit 1
    ;;
esac


exit 0
