#!/usr/bin/perl

use strict;
use Test::More;

use FindBin '$Bin';
use YAML;

my @files = glob "$Bin/../etc/ts-updater/*.conf";
for my $file (@files) {
    my ($conf) = eval { YAML::LoadFile $file };
    is($@, q{}, "$file: load yaml");
    is(ref $conf, 'HASH', "$file: hash");
}

done_testing;
