#!/bin/sh
export PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
inst_list="$@"
[ -z "$inst_list" ] && inst_list=$(lm --complete)

grant_list=fix-grants.sql

for inst in $inst_list; do 
  echo "`date` $0 start fixing grants in $inst"

  # db=$(echo "show databases;" | lm $inst | grep -v Database | grep -v information_schema | grep -v mysql | grep -v performance_schema | grep -v 'lost+found');
  case $inst in
    ppcdata*) dblist="ppc" ;;
    ppcmonitor) dblist=monitor ;;
    ppcordstat) dblist=direct_stat ;;
    ppcprofile) dblist=profile_logs ;;
    metrika) dblist=conv_main ;;
    partnerdb) dblist="adv_directory crm kladr partner vis_parser" grant_list="fix-grants.sql fix-grants-partner.sql";;
    partnerdb2) dblist="distribution partner kladr" grant_list="fix-grants.sql fix-grants-partner.sql";;
    *) dblist=$inst ;;
  esac

  echo "delete from mysql.user" | lm $inst
  echo "delete from mysql.db" | lm $inst
  echo "delete from mysql.tables_priv" | lm $inst
  for db in $dblist; do
    for grant_file in $grant_list; do
      grant=$(cat /opt/prepare-db/$grant_file | sed "s/\$db/$db/" )
      echo "$grant" | lm $inst
    done
  done
  echo "GRANT ALL PRIVILEGES ON *.* TO root@localhost WITH GRANT OPTION;" | lm $inst
  echo "flush privileges" | lm $inst >/dev/null 2>&1 || true

  echo "`date` $0 stop fixing grants in $inst"
done
