-- MySQL dump 10.13  Distrib 5.5.28, for Linux (x86_64)
--
-- Host: localhost    Database: conv_main
-- ------------------------------------------------------
-- Server version	5.5.28-29.2-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

CREATE DATABASE IF NOT EXISTS conv_main;
USE conv_main;

--
-- Table structure for table `counters`
--

DROP TABLE IF EXISTS `counters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `counters` (
  `counter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` bigint(20) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `site` varchar(255) DEFAULT NULL,
  `mirrors` mediumtext,
  `site_path` varchar(255) DEFAULT NULL,
  `mirrors_paths` mediumtext,
  `status` enum('Active','Deleted','New') NOT NULL DEFAULT 'Active',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `code_status` enum('undef','found','not_found','err_connect','err_code','err_dup','err_infected','err_other','err_timeout') NOT NULL DEFAULT 'undef',
  `code_status_info` text,
  `last_check` datetime NOT NULL,
  `create_time` datetime NOT NULL,
  `external_class` tinyint(3) unsigned NOT NULL,
  `external_cid` int(10) unsigned NOT NULL,
  `enable_monitoring` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `enable_sms` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `sms_time` text,
  `phone` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `flag` enum('','yamarket') NOT NULL DEFAULT '',
  `LayerID` int(3) unsigned NOT NULL,
  `MoveLayerID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `code_options` text,
  `informer_enabled` tinyint(3) NOT NULL DEFAULT '0',
  `informer_type` enum('counter','informer','together') NOT NULL,
  `informer_color` varchar(128) NOT NULL,
  `informer_indicators` varchar(128) NOT NULL,
  `start_monitoring_date` date DEFAULT NULL,
  `time_zone_id` int(11) unsigned NOT NULL DEFAULT '1',
  `currency_id` smallint(5) unsigned NOT NULL DEFAULT '643',
  `lang` char(2) NOT NULL DEFAULT 'ru',
  `turkish_rating_enabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `turkish_rating_category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `turkish_rating_started` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `widget_settings` text,
  `visit_threshold` smallint(5) unsigned NOT NULL DEFAULT '1800',
  `wv_visits_limit` int(11) unsigned DEFAULT NULL,
  `filter_robots` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `counter_rank` int(11) NOT NULL DEFAULT '1',
  `last_showed_code_status` enum('CS_ERR_EMPTY_DOMAIN_NAME','CS_ERR_HTML_CODE','CS_ERR_CONNECT','CS_ERR_INFECTED','CS_ERR_UNKNOWN','CS_ERR_DUPLICATED','CS_ERR_TIMEOUT','CS_OK','CS_NOT_FOUND','CS_WAIT_FOR_CHECKING') DEFAULT NULL,
  `max_offline_visit_threshold` int(10) unsigned NOT NULL DEFAULT '21600',
  `data_lifetime` int(10) unsigned NOT NULL DEFAULT '86400',
  PRIMARY KEY (`counter_id`),
  KEY `i_counters_owner` (`owner`),
  KEY `i_counters_updatetime` (`update_time`),
  KEY `i_counters_createtime` (`create_time`),
  KEY `i_ext` (`external_class`,`external_cid`),
  KEY `turkish_rating_enabled` (`turkish_rating_enabled`),
  KEY `last_check` (`last_check`),
  KEY `turkish_rating_enabled_active` (`turkish_rating_enabled`,`status`),
  KEY `counter_rank` (`counter_rank`)
) ENGINE=InnoDB AUTO_INCREMENT=40580391 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `external_counters`
--

DROP TABLE IF EXISTS `external_counters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `external_counters` (
  `external_cid` int(10) unsigned NOT NULL,
  `id` int(10) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  PRIMARY KEY (`external_cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders` (
  `orderid` int(10) unsigned NOT NULL,
  `owner` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`owner`,`orderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `orders_to_counters`
--

DROP TABLE IF EXISTS `orders_to_counters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders_to_counters` (
  `order_id` int(10) unsigned NOT NULL,
  `counter_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`order_id`,`counter_id`),
  KEY `c2o` (`counter_id`,`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ad_goals`
--

DROP TABLE IF EXISTS `ad_goals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ad_goals` (
  `goal_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `counter_id` int(10) unsigned NOT NULL DEFAULT '0',
  `serial` smallint(6) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `depth` int(10) unsigned NOT NULL,
  `goal_type` enum('url','number','step','action') NOT NULL DEFAULT 'url',
  `status` enum('Active','Deleted','Archived') NOT NULL DEFAULT 'Active',
  `mod_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `goal_flag` enum('','order','basket') NOT NULL DEFAULT '',
  `prev_goal_id` int(10) unsigned NOT NULL DEFAULT '0',
  `parent_goal_id` int(11) NOT NULL DEFAULT '0',
  `class` tinyint(4) DEFAULT '1',
  `last_step` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_retargeting` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`goal_id`),
  KEY `i_ad_goals_counter_id` (`counter_id`),
  KEY `mod_time` (`mod_time`)
) ENGINE=InnoDB AUTO_INCREMENT=6159442 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `AdvEngines2`
--

DROP TABLE IF EXISTS `AdvEngines2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AdvEngines2` (
  `Id` smallint(6) NOT NULL AUTO_INCREMENT,
  `AdvEngine` varchar(1000) NOT NULL,
  `ServiceNamePattern` varchar(1000) NOT NULL,
  `RefererPattern` varchar(1000) NOT NULL,
  `StrId` varchar(255) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `Filters`
--

DROP TABLE IF EXISTS `Filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Filters` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `CounterID` int(11) NOT NULL,
  `Serial` smallint(6) NOT NULL,
  `AttributeName` enum('Title','ClientIP','URL','Referer','UniqID') NOT NULL,
  `Type` enum('equal','start','contain','not_equal','not_start','not_contain','interval','not_in_interval','cut_parameter','cut_fragment','not_me','only_mirrors','merge_https_and_http','cut_all_parameters','to_lower','replace_domain') NOT NULL,
  `Value` text NOT NULL,
  `Data` text NOT NULL,
  `UpdateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Status` enum('Active','Deleted','Disabled') NOT NULL DEFAULT 'Active',
  `Name` text NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `IX_CounterID` (`CounterID`),
  KEY `IX_UpdateTime` (`UpdateTime`)
) ENGINE=InnoDB AUTO_INCREMENT=3374143 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `Interests`
--

DROP TABLE IF EXISTS `Interests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Interests` (
  `Id` int(11) NOT NULL,
  `Interest` varchar(50) DEFAULT NULL,
  `StrId` varchar(255) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `MobilePhones`
--

DROP TABLE IF EXISTS `MobilePhones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MobilePhones` (
  `Id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `Weight` smallint(5) NOT NULL DEFAULT '0',
  `MobilePhone` varchar(1000) NOT NULL,
  `Pattern` varchar(1000) NOT NULL,
  `IsTablet` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `OS` smallint(5) unsigned NOT NULL DEFAULT '0',
  `AlternativeNames` varchar(1000) NOT NULL DEFAULT '',
  `StrId` varchar(255) NOT NULL,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `MobilePhone` (`MobilePhone`(25))
) ENGINE=MyISAM AUTO_INCREMENT=126 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `OS2`
--

DROP TABLE IF EXISTS `OS2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `OS2` (
  `Id` bigint(10) unsigned NOT NULL DEFAULT '0',
  `Parent_Id` bigint(10) unsigned DEFAULT NULL,
  `OS` varchar(1000) NOT NULL,
  `UATraitsName` varchar(1000) NOT NULL,
  `OSMajor` varchar(3) NOT NULL DEFAULT '',
  `OSMinor` varchar(3) NOT NULL DEFAULT '',
  `IsMobile` tinyint(1) NOT NULL DEFAULT '0',
  `IsNotMobile` tinyint(1) NOT NULL DEFAULT '0',
  `IsOther` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Sort` int(11) NOT NULL DEFAULT '100',
  `StrId` varchar(255) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `Place`
--

DROP TABLE IF EXISTS `Place`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Place` (
  `PlaceID` int(11) NOT NULL AUTO_INCREMENT,
  `PlaceParentID` int(11) NOT NULL DEFAULT '0',
  `PlaceSequentID` int(11) NOT NULL DEFAULT '0',
  `ExtBlockID` int(11) NOT NULL DEFAULT '0',
  `BannerLimit` int(11) NOT NULL DEFAULT '0',
  `BannerType` tinyint(4) NOT NULL DEFAULT '0',
  `PlaceAll` tinyint(4) NOT NULL DEFAULT '0',
  `AddContexts` tinyint(4) NOT NULL DEFAULT '1',
  `PlaceSelect` tinyint(4) NOT NULL DEFAULT '0',
  `Flags` set('OrderUnique','PlaceWrap') CHARACTER SET koi8r DEFAULT '',
  `WantStat` tinyint(4) NOT NULL DEFAULT '0',
  `Options` set('wantstat','mobile','deleted') NOT NULL DEFAULT '',
  `PlaceDescription` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`PlaceID`)
) ENGINE=InnoDB AUTO_INCREMENT=1111 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `SearchEngines`
--

DROP TABLE IF EXISTS `SearchEngines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SearchEngines` (
  `Id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `SearchEngine` varchar(1000) NOT NULL,
  `ParentId` bigint(10) unsigned DEFAULT NULL,
  `weight` int(8) NOT NULL,
  `URL` varchar(1000) NOT NULL,
  `form_num` int(11) DEFAULT NULL,
  `field_name` varchar(1000) NOT NULL,
  `Hide` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `CheckType` enum('Full','Redirect','None') NOT NULL DEFAULT 'Full',
  `PageParameterPattern` varchar(255) DEFAULT NULL,
  `PageParameterOffset` tinyint(1) DEFAULT NULL,
  `PageParameterDivisor` tinyint(1) DEFAULT NULL,
  `StrId` varchar(255) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `FK_ParentId` (`ParentId`)
) ENGINE=MyISAM AUTO_INCREMENT=190 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `SearchEngines_Patterns`
--

DROP TABLE IF EXISTS `SearchEngines_Patterns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SearchEngines_Patterns` (
  `Id` bigint(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'In order of priority',
  `SearchEngineId` bigint(10) unsigned NOT NULL,
  `Pattern` varchar(1000) NOT NULL COMMENT '1st subpattern is search phrase',
  `QuickPattern` varchar(1000) NOT NULL COMMENT 'for check with strcasecmp',
  `Charset` enum('Auto','KOI8R') NOT NULL DEFAULT 'Auto',
  PRIMARY KEY (`Id`),
  KEY `FK_SearchEngineId` (`SearchEngineId`)
) ENGINE=MyISAM AUTO_INCREMENT=98 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `SearchEngines_SimplePatterns`
--

DROP TABLE IF EXISTS `SearchEngines_SimplePatterns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SearchEngines_SimplePatterns` (
  `SearchEngineID` int(10) unsigned NOT NULL,
  `Domains` varchar(1000) NOT NULL COMMENT 'Without ''www'', comma separated.',
  `Parameters` varchar(1000) NOT NULL COMMENT 'Comma separated.',
  `PhraseRequired` tinyint(1) NOT NULL DEFAULT '1',
  `Charset` enum('Auto','KOI8R','GB2312') NOT NULL DEFAULT 'Auto',
  PRIMARY KEY (`SearchEngineID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `SocialNetworks`
--

DROP TABLE IF EXISTS `SocialNetworks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SocialNetworks` (
  `Id` smallint(6) NOT NULL AUTO_INCREMENT,
  `Name` varchar(1000) NOT NULL,
  `FirstSignificantSubdomain` varchar(1000) NOT NULL,
  `Pattern` varchar(1000) NOT NULL COMMENT 'may contain subpattern with social network page',
  `Exceptions` varchar(1000) NOT NULL,
  `StrId` varchar(255) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `TraficSources`
--

DROP TABLE IF EXISTS `TraficSources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TraficSources` (
  `Id` bigint(10) NOT NULL AUTO_INCREMENT,
  `TraficSource` varchar(1000) NOT NULL,
  `StrId` varchar(255) NOT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ad_goals_urls`
--

DROP TABLE IF EXISTS `ad_goals_urls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ad_goals_urls` (
  `goal_id` int(10) unsigned NOT NULL,
  `serial` int(10) unsigned NOT NULL,
  `pattern_type` enum('exact','start','contain','regexp','action') NOT NULL,
  `url` varchar(16384) DEFAULT NULL,
  PRIMARY KEY (`goal_id`,`serial`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bs_pages`
--

DROP TABLE IF EXISTS `bs_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pages` (
  `PageID` int(11) NOT NULL DEFAULT '0',
  `domain` mediumtext NOT NULL,
  `TargetType` int(11) NOT NULL DEFAULT '0',
  `descr` mediumtext,
  `name` varchar(200) NOT NULL,
  `group_nick` varchar(200) NOT NULL DEFAULT 'nd',
  `sorting` int(11) NOT NULL DEFAULT '9',
  `State` tinyint(4) NOT NULL DEFAULT '1' COMMENT '-1 - blocked, 0 - testing, 1 - working',
  PRIMARY KEY (`PageID`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `counter_options`
--

DROP TABLE IF EXISTS `counter_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `counter_options` (
  `counter_id` int(10) unsigned NOT NULL,
  `max_goals` int(10) unsigned NOT NULL DEFAULT '0',
  `max_detailed_goals` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `max_conditions` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `wv_recp` decimal(10,5) DEFAULT NULL,
  `wv_urls` varchar(1000) DEFAULT NULL,
  `wv_arch_type` varchar(16) DEFAULT NULL,
  `wv_arch_enabled` tinyint(1) DEFAULT NULL,
  `wv_load_player` enum('proxy','on_your_behalf') DEFAULT NULL,
  `region_details` tinyint(1) DEFAULT NULL,
  `markedphones2_params` text,
  `max_retargeting_goals` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`counter_id`),
  KEY `NewIndex1` (`update_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `UserAgent`
--

DROP TABLE IF EXISTS `UserAgent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `UserAgent` (
  `Id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `Weight` smallint(5) NOT NULL DEFAULT '0',
  `Sort` int(11) NOT NULL DEFAULT '0',
  `UserAgent` varchar(1000) NOT NULL,
  `Pattern` varchar(1000) NOT NULL DEFAULT '',
  `IsMobile` tinyint(1) NOT NULL DEFAULT '0',
  `Tokens` varchar(255) NOT NULL DEFAULT '',
  `UATraitsName` varchar(1000) NOT NULL DEFAULT '',
  `StrId` varchar(255) NOT NULL,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `UATraitsName` (`UATraitsName`(100))
) ENGINE=MyISAM AUTO_INCREMENT=117 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `TraficSources_Patterns`
--

DROP TABLE IF EXISTS `TraficSources_Patterns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TraficSources_Patterns` (
  `TraficSourceID` bigint(10) NOT NULL,
  `EngineID` smallint(6) NOT NULL,
  `Domains` varchar(1000) NOT NULL COMMENT 'Without ''www'', comma separated.',
  `FirstSignificantSubdomain` varchar(1000) NOT NULL,
  `Parameters` varchar(1000) NOT NULL COMMENT 'Comma separated.',
  `CheckPattern` varchar(1000) NOT NULL,
  `ExtractPattern` varchar(1000) NOT NULL,
  `Exceptions` varchar(1000) NOT NULL,
  `PhraseRequired` tinyint(1) NOT NULL DEFAULT '1',
  `Charset` enum('Auto','KOI8R','GB2312') NOT NULL DEFAULT 'Auto',
  `RejectPattern` varchar(1000) NOT NULL,
  `SearchEngineIDForAdvEngine` smallint(6) NOT NULL
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2014-10-12 13:36:35
