#!/bin/bash

set -e
exec 999>/var/run/`basename $0`.lock
flock -n 999 || exit 1
echo $$ 1>&999

die() {
  echo "`date` $@"
  exit 1
}
log() {
  echo "`date` $@"
}

sock=/var/run/mysqld.metrika/mysqld.sock
db=conv_main
new_dir=/opt/metrika.tsv.syncing
ready_dir=/opt/metrika.tsv.synced
src=mtexport.yandex.ru::generic/

log "Start syncing metrika tables"

mkdir $ready_dir >/dev/null 2>&1 || true
[ $(rsync -rni $src $ready_dir | wc -l) -eq 0 ] && die "exiting, no changed tables on mtexport"

mkdir $new_dir >/dev/null 2>&1 || true
rsync -av --whole-file $src $new_dir
log "raw files synced"

mysql -S $sock < /opt/prepare-db/metrika.schema.sql
log "new schema loaded"

/opt/prepare-db/fix-grants.sh metrika
log "grants fixed"

set +e
cd $new_dir
for i in *.gz; do
  shortName=${i%%.gz}
  splitName=${i%%.gz}"Split"
  tableName=${shortName%%.tsv}
  gunzip -c $i > $shortName
  # Большие файлы CVS плохо загружаются в MySQL. Сплитим файлики.
  split -l 1000000 $shortName $splitName
  for name in $splitName*; do 
    log "load data local infile '$name' into table $tableName"
    echo "load data local infile '$name' into table $tableName" | mysql --local-infile -S $sock $db
    rm $name
  done
  rm $shortName
done

log "delete from $db.counters where LayerID = 0"
echo "delete from $db.counters where LayerID = 0" | mysql --local-infile -S $sock $db

log "rename $new_dir to $ready_dir"
rm -rf $ready_dir >/dev/null 2>&1 || true
mv $new_dir $ready_dir
log "Done"

