#!/bin/bash
conf=$1
shift
if [ -z "$conf" ]; then
  echo "Usage: `basename $0` (april|partner) [--force] [sync-db args]"
  exit 1
fi
# silently exit in case of absent config
[ -f /etc/sync-db/$conf.conf ] || exit 1

pidfile=/tmp/sync-db-$conf

log() {
  echo "`date` $@"
}

kill_sync_db() {
  pid=$1
  [ -z "$pid" ] && return

  log "try to kill main process ..."
  kill $pid
  sleep 10

  ps -e -o pid,cmd | grep -E '([s]ync-db\.pl|[r]sync)' | grep -q $conf || return
  log "kill all suspicious survivors ..."
  for i in seq 10; do
    ps -e -o pid,cmd | grep -E '([s]ync-db\.pl|[r]sync)' | grep $conf | awk '{ print $1 }' | xargs kill
    sleep 1
  done

  ps -e -o pid,cmd | grep -E '([s]ync-db\.pl|[r]sync)' | grep -q $conf || return
  log "last shot ..."
  ps -e -o pid,cmd | grep -E '([s]ync-db\.pl|[r]sync)' | grep $conf | awk '{ print $1 }' | xargs kill -9
}

if [ x"$1" == x"--force" ]; then
  shift
  [ -f $pidfile ] && pid=$(cat $pidfile)
  [ -z "$pid" ] && pid=$(ps -e -o pid,cmd | grep [s]ync-db.pl | grep april | awk '{ print $1 }' | head -1) 
  kill_sync_db $pid
  rm $pidfile
fi

/usr/local/bin/sync-db.pl --copy-db --date today --rsync-opts bwlimit=90000 --rsync-opts whole-file=1 --conf /etc/sync-db/$conf.conf $@
