#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use Yandex::Staff3 qw( get_staff_info_ext );
use Yandex::HTTP ();
use Startrek::Client::Easy ();
use Yandex::Advmon ();
use Yandex::Retry;

use JSON;
use DDP;

my @QUEUES = qw(DIRECT DIRECTSUP DIRECTMOD DIRECTMODSUP DIRECTADMIN GEOCONTEXT TESTIRT DIRECTCLIENT);
my @GROUPS = qw(yandex_monetize_search_direct yandex_monetize_search_direct_interface);

print "Fetching logins...\n";
my $logins = get_logins();
my $logins_str = join(',', @$logins);
my $queues_str = join(',', @QUEUES);
my $page = 1;
my (%stat, %component_stat);
my $st = Startrek::Client::Easy->new();
while(1) {
    print "Fetching page $page...\n";
    my $tickets = retry tries => 3, pauses => [1], sub { $st->get(query => "(Assignee: $logins_str OR Queue: $queues_str) and Status: !Closed", page => $page, array => 1) };
    die "Tickets should be an ARRAY" unless ref($tickets) eq 'ARRAY';
    last unless $tickets && @$tickets;
    for my $ticket (@$tickets) {
        $stat{ $ticket->{assignee} || 'UNASSIGNED' }->{ $ticket->{queue} }->{ $ticket->{status} || 'NOSTATUS' }++;
        if ($ticket->{components}) {
            for my $component_id (@{$ticket->{components}}) {
                $component_stat{$component_id}->{ $ticket->{assignee} || 'UNASSIGNED' }->{ $ticket->{queue} }->{ $ticket->{status} || 'NOSTATUS' }++;
            }
        }
    }
    $page++;
}
local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min global/]};
Yandex::Advmon::monitor_values({startrek => \%stat});
Yandex::Advmon::monitor_values({startrek_components => \%component_stat});

=head2 get_logins

    Возвращает список людей из групп, входящих в @GROUPS

    $logins = get_logins();
    $logins => [$login1, $login2, ...]

=cut

sub get_logins {
    my @logins;
    my $data = get_staff_info_ext('persons', (_limit => 500,
                                              'official.is_dismissed' => 'false',
                                              'department_group.ancestors.url' => join(',', @GROUPS),
                                              _fields => 'login'));
    push @$data, @{get_staff_info_ext('persons', (_limit => 500,
                                                  'official.is_dismissed' => 'false',
                                                  'department_group.url' => join(',', @GROUPS),
                                                  _fields => 'login'))};
    push @logins, map {$_->{login}} @$data;
    
    return \@logins;
}
