#!/bin/bash -e

scriptname=$(basename $0)
pidfile="/run/${scriptname}"
 
# lock it
exec 200>$pidfile
flock -n 200 || exit 1
pid=$$
echo $pid 1>&200

trap 'for z in $(echo $TO_BACKUP); do echo "Failed: $(date +%s)" > /var/spool/mongodb-monitor/${z}-success; done' KILL TERM INT HUP

DB_LIST=$(ls -d /opt/mongodb-* | sed 's/\/opt\/mongodb-//g')
TO_BACKUP=$DB_LIST
RSYNC_COMMON_OPTS="-rl --numeric-ids --sockopts=SO_SNDBUF=2000000,SO_RCVBUF=2000000 --whole-file --ignore-times --timeout=1800 --contimeout=20"
backupdir="fastbone.ppcbackup03h.yandex.ru::mongo-rw/ppcfiles"

echo "Starting... $(date)"

# if gluster share is mounted, umount it to be shure, that everything is working ok and not stalled
#grep -q '/mnt/glusterfs' /proc/mounts && /bin/umount '/mnt/glusterfs'

#/bin/mount /mnt/glusterfs


for i in $DB_LIST; do

# clean up
    rm -rf /mnt/backup/"$i"-info/
    grep -q "/mnt/backup/mongodb-${i}/" /proc/mounts && umount /mnt/backup/mongodb-${i}/
    [ -b /dev/vg0/backup-mongodb ] && lvremove -f /dev/vg0/backup-mongodb
    status mongodb-${i} | grep -q '/running'

    # checking replica
    [ "$(echo 'rs.isMaster().setName' | mongo --quiet | grep -v 'bye')" == "$i" ]
    [ "$(echo 'rs.isMaster()' | mongo --quiet | grep -E 'secondary|passive|hidden' | grep 'true' | wc -l)" -eq "3" ]

    # saving information about backup
    mkdir -p /mnt/backup/"$i"-info/
    cp -a /etc/mongodb/"$i".conf /mnt/backup/"$i"-info/
    dpkg -l yandex-direct-mongodb-"$i" > /mnt/backup/"$i"-info/pkg_version

    # locking database (doesn't work so commented)
    #echo -e "use admin;\n db.runCommand({fsync:1,lock:1});" | mongo --quiet > /dev/null
    #echo -e "var stat = rs.status();\n stat.members.forEach( function (x) {if (x.self) {print('Timestamp(' + x.optime.t + ', ' + x.optime.i + ')')}});" | mongo --quiet | grep -v 'bye' > /mnt/backup/"$i"-info/current_position
    date > /mnt/backup/"$i"-info/backup_date

    /sbin/stop mongodb-"$i"
    date > /mnt/backup/"$i"-info/backup_date
    lvcreate -L100G -s -n backup-mongodb /dev/vg0/backup-mongodb-${i}
    /sbin/start mongodb-"$i"

    [ -d /mnt/backup/mongodb-${i}/ ] || mkdir /mnt/backup/mongodb-${i}/
    mount /dev/vg0/backup-mongodb /mnt/backup/mongodb-${i}/

    rsync $RSYNC_COMMON_OPTS /dev/null $backupdir/ >/dev/null 2>&1
    rsync $RSYNC_COMMON_OPTS --delete /mnt/backup/mongodb-${i}/mongodb-${i} $backupdir/tmp/
    touch /mnt/backup/"$i"-info/.rsnap_prot0
    rsync $RSYNC_COMMON_OPTS /mnt/backup/"$i"-info/ $backupdir/tmp/
    
    umount /mnt/backup/mongodb-${i}/
    lvremove -f /dev/vg0/backup-mongodb
    rm -rf /mnt/backup/"$i"-info/

    date +"%s" > /var/spool/mongodb-monitor/"$i"-success
    TO_BACKUP=${TO_BACKUP#* }

done

#/bin/umount /mnt/glusterfs

echo "Finished. $(date)"

exit 0
