#!/bin/bash

DIR='/var/spool/mysql-monitor/'

if [ ! -d "$DIR" ]; then
    echo "1;Warning: $DIR is not a directory"
    exit 0
fi

failmessage=""
okmessage=""
warnmessage=""

ERROR=""
ls -1 "$DIR"/*-status >/dev/null 2>&1 || ERROR="2;Failed: not found any $DIR/*-status" 
if [ -n "$ERROR" ]; then
    echo $ERROR
    exit 0
fi

for i in $(ls -1 "$DIR"/*-status); do
    success_status=$(cat $i)
    instance=$(basename $i | sed 's/-status//g')
    age=$((`date +%s` - `stat -c %Y $i`))
    if [[ "$success_status" == "PROGRESS" ]]; then
        # continue if backup is not finished (8 hours)
	okmessage="${okmessage}[progress snapshot:: $instance], "
        [[ $age -lt 86400 ]] && continue
	warnmessage="${warnmessage}[stalled snapshot:: $instance], "
    elif [[ "$success_status" == "SUCCESS" ]]; then
        okmessage="${okmessage}[success snapshot:: $instance], "
    elif [[ "$success_status" == "FAILURE" ]]; then
	failmessage="${failmessage}[corrupt backup:: $instance],"
    else
        failmessage="${warnmessage}[wrong status:: $instance], "
    fi
done


if [ ! -z "$failmessage" ]; then
    echo "2;Failed: $(echo $failmessage | sed 's/,$/\./g')"
elif [ ! -z "$warnmessage" ]; then
    echo "1;Warning: $(echo $warnmessage | sed 's/,$/\./g')"
elif [ ! -z "$okmessage" ]; then
    echo "0;OK: $(echo $okmessage | sed 's/,$/\./g')"
elif [ -z "$failmessage" -a -z "$warnmessage" -a -z "$okmessage" ]; then
    echo '0;OK'
else
    echo "2;Failed: script error (can't check)"
fi


exit 0


