#!/usr/bin/python
# *-* encoding: utf-8 *-*

import urllib
import urllib2
import socket
import json
import time
import sys

TOKEN_PATH = '/etc/direct-tokens/juggler_api'

def readToken(token_path=TOKEN_PATH):
    token = ""
    try:
        with open(token_path, 'r') as token:
            token = token.read()
    except Exception as err:
         print 'Error read token: {0}'.format(err)
    return token

def useJuggler(url, action, params):
    msg, code = dict(), 1
    url += action
    addr = '?'.join([url, urllib.urlencode(params)])
    req = urllib2.Request(addr)
    token=readToken(TOKEN_PATH)
    req.add_header('Authorization', 'OAuth {0}'.format(token))
    try:
        resp = urllib2.urlopen(req)
        msg, code = json.loads(resp.read()), resp.getcode()
    except Exception as err:
        print 'Error func useJuggler():', str(err)
    return msg, code

if __name__ == '__main__':
    my_fqdn = socket.getfqdn()
    url = 'http://juggler-api.search.yandex.net:8998/api/downtimes/'
    params = {'object_name': my_fqdn, 'do': '1'}
    action = 'downtimes'
    downtime, _ = useJuggler(url, action, params)
    # downtime может содержать значения с ключами отличными от "". Проверяем. 
    if downtime > {} and downtime.get('HOST').get(my_fqdn).has_key(""):
        end_time = downtime.get('HOST').get(my_fqdn).get("").get('end_time', 0)
    else:
        end_time = 0
    print(end_time)
    if end_time < int(time.time()):
        params = { 'object_name': my_fqdn,
               'description': 'Auto downtime for backup',
               'end_time': '+720min',
               'do': '1'}
        action = 'set_downtime'
        _, set_dt = useJuggler(url, action, params)
        if set_dt == 200:
            print('Create downtime success\n')
        else:
            print('Error create downtime:', str(set_dt))
    else:
        print('Downtime already set to ', str(end_time))
