#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import urllib2
import time
import socket
import sys

# За какое время считать список фалпов.
#time_window=144000
time_window=1800

slb_list=['api.direct.yandex.ru','direct.yandex.ru','intapi.direct.yandex.ru','metrika.yandex.ru','api-metrika.yandex.ru']

dc_dict={	'Амстердам'	:	'ams',
		'Ивантеевка'	:	'iva',
		'Лас-Вегас'	:	'veg',
		'Мытищи'	:	'myt',
		'Сасово'	:	'sas',
		'Угрешка'	:	'ugr',
		'Фольга'	:	'fol',
		'ЭТО'	:	'eto'	
}

url_base='https://slbloghandler.yandex-team.ru/jsrpc.php?action=get_data&from=%d&to=%d&rsshow=1&vsg=%s'
url_dc_list='https://slbloghandler.yandex-team.ru/jsrpc.php?action=apply_filters&vsg=%s&mode=api'

timestamp = int(time.time())
prev_timestamp = timestamp - time_window

def get_data(url):
	result_json  = urllib2.urlopen(url).read()
        json_data=json.loads(result_json)
	return json_data

def get_dc_list(slb):
	dc_list=[]
	url = url_dc_list % (slb)
	json = get_data(url)
	for dc in json['dc']:
		dc_list.append(resolve_dc(dc['name']))
	return dc_list

def resolve_dc(dcname):
        for name in dc_dict:
            if dcname.encode('utf-8').startswith(name):
                dc_short_name=dc_dict[name]
                #print name, dcname, dcname.encode('utf-8').startswith(name), dc_dict[name]
                break
        else:
                raise KeyError('Not found DC in dc_dict')
	#dc_short_name=dc_dict[dcname.encode('utf-8')]
	return dc_short_name

def count_flaps(slb, dc_list) :

	result_list=[]
	url = url_base % (prev_timestamp, timestamp, slb)
	json_data = get_data(url)
	
	flaps = {}
	flaps['rs'] = {}
	flaps['vs'] = {}
	for dc in dc_list:
                flaps['rs'][dc] = 0
                flaps['vs'][dc] = 0

	for flap in json_data:
		if flap['type'] == 'rs-down':
			dc_name=resolve_dc(flap['dcname'])
			try:
				flaps['rs'][dc_name] += 1
			except KeyError:
                                flaps['rs'][dc_name] = 0

		if flap['type'] == 'vs-down':
			dc_name=resolve_dc(flap['dcname'])
			try:
				flaps['vs'][dc_name] += 1
			except KeyError:
				flaps['vs'][dc_name] = 0

	for dc in flaps['rs']:
		result_list.append("five_min.%s.slbflaps.rs.%s %s %d" % (slb.replace('.','_'), dc, flaps['rs'][dc],timestamp))
	for dc in flaps['vs']:
		result_list.append("five_min.%s.slbflaps.vs.%s %s %d" % (slb.replace('.','_'), dc, flaps['vs'][dc],timestamp))

	return result_list

def send_data(data):
        sock=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
        sock.connect(('localhost',42000))
        sock.send('\n'.join(data))
        sock.close()

if __name__ == "__main__":
	for slb in slb_list:
		result_list=get_dc_list(slb)

		data=count_flaps(slb, result_list)
        	#print data
		send_data(data)

