#!/bin/sh -e
# creating system users (ids from 9000 to 9999)

user="robot-direct-admin"
# FIX PASSWORD BELOW IF NEEDED
# FIX SUDO STRING AND PATTERN

#ID in system
k="2000"

USER_HOME_DIR="/home/${user}"
USER_SHELL="/bin/sh"
#USER_HOME_LINK="/opt/broadmatching"
#SUDO_GRANTS="0" # bash-like style: zero TURNS ON sudo grants
SUDO_FILE_NAME="autoadmin"

case "$1" in
    create)
        if ! id $user > /dev/null 2>&1; then
	    adduser --uid "$k" --group --system --quiet --shell "$USER_SHELL" --home "$USER_HOME_DIR" "$user" || {
		echo "Failed to create $user user."
	    }
        fi

        chown -R "$user": "$USER_HOME_DIR"
        chmod u=rwX,g=rX,o=rX /home/${user}/ || true
        chmod -R u=rwX,g=,o= /home/${user}/.ssh || true
        # ln -s "$USER_HOME_DIR" "$USER_HOME_LINK" && echo "Link $USER_HOME_LINK was created successfully."
        [ -f /etc/sudoers.d/"$SUDO_FILE_NAME" ] || {
            echo "Missing /etc/sudoers.d/$SUDO_FILE_NAME"
        }
	#grep -R "$user" /etc/sudoers* || true
        # echo "Changing passwords for $user..."
        # chpasswd -e "$user": #_PUT_ENCRYPTED_PASSWORD_HERE_IF_NEEDED_#
    ;;

    remove)
	echo "Removing sudo grants ..."
	rm -f /etc/sudoers.d/"$SUDO_FILE_NAME"
#        deluser "$user" || {echo "$user wasn't delete." && exit 1}
	deluser --remove-home "$user" || true
	if $(id "$user" > /dev/null 2>&1); then
	    echo "$user wasn't removed successfuly."
	else
	    true
	fi

	grep -R "$user" /etc/sudoers* || true
    ;;

    *)
        echo "unknown argument \`$1'" >&2
        exit 1
    ;;
esac

exit 0
