#!/usr/bin/python
# *-* encoding: utf-8 *-*

import sys, os
import json
import optparse
import time
from subprocess import PIPE, Popen

DIR = '/etc/check-db-schema.d/'

def run_shell(cmd):
    if debug: print '[run_shell:request]', str(cmd)
    request = Popen(str(cmd), shell=True, 
                stderr=PIPE, stdout=PIPE)
    stdout, stderr = request.communicate()
    if debug: print '[run_shell:result]', request.returncode, stdout.strip(), stderr.strip()
    return request.returncode, stdout.strip(), stderr.strip()


def main(db_name):
    rcode, lm_json, err = run_shell('/usr/local/bin/lm %s status-json' % db_name)
    if rcode != 0:
        raise ValueError('0;Info: mysql (%s) is down or absent' % str(db_name))

    mst = json.loads(lm_json.decode('utf-8','ignore'))
    #sql_slave = mst['slave_status']['Slave_SQL_Running'] 
    #io_slave = mst['slave_status']['Slave_IO_Running']  
    #lm_master = mst['slave_status']['Master_Host'] 
    lm_port = mst['port']

    db_schema_file = os.path.join(DIR, db_name)
    if not os.path.exists(db_schema_file):
        raise ValueError('2;Failed: config doesnt exist')
 
    with open(db_schema_file) as _file:
        dbconfig_cmd = [ i.split('=')[1].strip() for i in _file.readlines() 
                                         if i.count('dbconfig-explorer')][0]
    rcode, my_role, err = run_shell('%s --show-my-role' % str(dbconfig_cmd))
    if rcode != 0:
        raise ValueError('2;Failed: external script failed')
    if not my_role:
        raise ValueError('2;Failed: empty role')
    my_role = my_role.split('\n')
    my_role.sort()

    count = 0
    while True:
        rcode, lfw_raw, err = run_shell('sudo /usr/local/bin/lfw %s' % str(db_name))
        if rcode == 0: 
            break
        time.sleep(1)
        if count >= 3: 
            raise ValueError('2;Failed: lfw not working')
    
    lfw_status = [ i.split('->')[1].strip() for i in lfw_raw.split('\n') 
                                           if i.count('write')][0]

    if my_role.count('none') and not lfw_status.count('X'):
        raise ValueError('2; Failed: lfw isnt closed')

    if not my_role.count('none') and not str(lfw_status).count(str(lm_port)):
        raise ValueError('2;Failed: lfw is closed or broken (my_role: %s)' % my_role)
    
    raise ValueError('0;OK: %s' % my_role)

if __name__ == '__main__':

    usage = "usage: check-lfw.py <hostname>"
    parser = optparse.OptionParser(usage=usage)
    parser.add_option( "-d", "--debug", action="store_true", dest="debug")
    (opts, args) = parser.parse_args()
    debug = opts.debug

    try:
        for db_name in args:
            main(db_name)
    except ValueError as err:
        print str(err)
