#!/bin/bash

set -e

# dependency: yandex-du-lm

# $1 -- instance name

read sql_slave io_slave lm_master lm_port lm_rc <<< $(/usr/local/bin/lm "$1" status-json 2> /dev/null | python -c "import sys, json; mst = json.loads(sys.stdin.read().decode('utf-8','ignore')); print mst['slave_status']['Slave_SQL_Running'], mst['slave_status']['Slave_IO_Running'], mst['slave_status']['Master_Host'], mst['port'], 0"  2> /dev/null || echo "- - - - $?")

if [[ "$lm_rc" -ne 0 ]]; then
    echo "0;INFO: mysql ($i) is down or absent"
    exit 0 # mysql is down or dead
fi


dir="/etc/check-db-schema.d/"

if [ ! -f "$dir"/"$1" ]; then
    echo "2;Failed: config doesn't exist"
    exit 0
fi


if [ "$sql_slave" == "Yes" -a "$io_slave" == "Yes" ]; then
    error_file=$(mktemp)
    cmd=$(/bin/grep '^command' "$dir"/"$1" | head -1 | cut -d'=' -f2)
    read -r RETVAL zk_master_revert 2>"$error_file" <<< $(echo $($cmd --show-master | head -1; echo ${PIPESTATUS[0]} ) | rev)
    if [[ "$RETVAL" -eq 0 ]]; then
	    zk_master=$(echo "$zk_master_revert" | rev)
        rm $error_file
    else
	    echo "2;Failed: $(< error_file)"
        rm $error_file
	exit 1
    fi

    if [ -z "$zk_master" -o -z "$lm_master" ]; then
	echo "2;Failed: Can't retrieve master"
	exit 0
    fi

    if [ "$zk_master" == "$(hostname -f)" ]; then
	echo "0;OK: I'm master"
	exit 0
    elif [ "$zk_master" != "$lm_master" ]; then
	echo '2;Failed: wrong replication schema'
	exit 0
    fi
elif [ "$sql_slave" == "No" -o "$io_slave" == "No" ]; then
    echo '0;Warning: replica is dead'
    exit 0
fi


echo '0;OK'

