#!/bin/bash

# check functions
#
# true if OK
# "1;warning message" or "2;error message" to stdout

. /usr/lib/yandex-du-check-state/du-check-state-functions


w_messages=""
e_messages=""

declare -A enabled_checks

# checks
#enabled_checks[kernel_version]="check-kernel-version 3.8"
enabled_checks[check-var-mail-root]="check-var-mail-root"
#enabled_checks[key]="function_name [argument]"


if [ "$1" == '--list' ]; then
    echo "${!enabled_checks[@]}"
    exit 0
fi
if [ "$1" == '--check' ]; then
    res=$(${enabled_checks[$2]})
    echo $res
    exit 0
fi


for k in "${!enabled_checks[@]}"; do
    res=$(${enabled_checks[$k]})
    if [[ -z $res ]]; then
	continue
    else
	case ${res%%;*} in
	    1)
#		w_messages+=", ${res:2}"
		w_messages+=", $k"
		;;
	    2)
#		e_messages+=", ${res:2}"
		e_messages+=", $k"
		;;
	    *)
		e_messages+=", broken [ $k ]"
		;;
	esac
    fi
done


if [ ! -z "$e_messages" ]; then
    echo "2;Failed: ${e_messages:2} # more info: 'du-state-show-check checkname' & 'du-state-list-checks'"
elif [ ! -z "$w_messages" ]; then
    echo "1;Warning: ${w_messages:2} # more info: 'du-state-show-check checkname' & 'du-state-list-checks'"
#elif [ ! -z "$okmessage" ]; then
#    echo "0;OK >> creating backup: $(echo $okmessage | sed 's/,$/\./g')"
elif [ -z "$failmessage" -a -z "$warnmessage" ]; then
    echo '0;OK'
else
    echo "2;Failed: script error (can't check)"
fi


exit 0


