#!/usr/bin/python2
# *-* encoding: utf8 *-*

from subprocess import Popen, PIPE

class EDAC_critical(Exception):
    '''Генерирует error сообщение monrun'a '''
    def __init__(self, msg):
        self.msg = ';'.join(['2', 'Critical - ' + msg])

    def __str__(self):
        return str(self.msg)

class EDAC_warning(Exception):
    '''Генерирует warning сообщение monrun'a ''' 
    def __init__(self, msg):
        self.msg = ';'.join(['1', 'Warning - ' + msg])

    def __str__(self):
        return str(self.msg)

class EDAC_info(Exception):
    '''Генерирует info сообщение monrun'a ''' 
    def __init__(self, msg):
        self.msg = ';'.join(['0', 'OK - ' + msg])

    def __str__(self):
        return str(self.msg)

class EDAC(EDAC_critical, EDAC_warning, EDAC_info):
    ''' Общий класс для работы с EDAC '''
    def __init__(self):
        ''' Задаем имя тулзы и код возврата, 
            который нас устраивает.
        '''
        self.command = 'edac-util'
        self.ignore_code = [0, 1]
        
    def __call__(self):
        ''' Вызываем основные функции '''
        self.do_cmd()
        self.parse_edac()
 
    def do_cmd(self, cmd=None, cwd_err=None, cwd_in=None, 
               cwd_out=None, cwd_shell=True, cwd_buff=0, 
               cwd_pre=None):
        ''' Функция обертка над subprocess '''
        cmd = cmd if cmd else self.command
        command = Popen(cmd, stdout=PIPE, stdin=cwd_in, 
                        stderr=PIPE, bufsize=cwd_buff, 
                        shell=cwd_shell, preexec_fn=cwd_pre)
        _code = command.wait()
        _stderr = command.stderr.read()
        _stderr = ' '.join(_stderr.split('edac-util:')[1:]).strip()
        _stdout = command.stdout.read().strip()
        self.return_value = _code, _stderr, _stdout

    def parse_edac(self, return_value=None, ignore_code=None):
        ''' Функция для парсинга вывода с edac-util. Принимает значения 
            return_value и ignore_code. Если параметры не передаются, то
            берутся значения с методов объекта self.return_value и self.ignore_code.
            return_value = (code, stderr, stdout), ignore_code = [0, 1]
        '''
        _code, _stderr, _stdout = return_value if return_value else self.return_value
        _ignore_code = ignore_code if ignore_code else self.ignore_code
        if _code not in _ignore_code:
            raise EDAC_warning(_stderr)
        elif _stdout.find('No errors to report') !=-1:
            raise EDAC_info('No errors to report')
        elif _stderr:
            raise EDAC_info(_stderr)
        else:
            _result = 'BAD DIMM:'
            for _string in _stdout.split('\n'):
                _result = ' '.join([_result, _string.split(': ')[2]]).strip()
            raise EDAC_warning(_result)

 
if __name__ == "__main__":
    ''' Генерируем вывод для monrun '''
    value = EDAC()
    try:
        value()
    except (EDAC_critical, EDAC_info, EDAC_warning) as monrun:
        print monrun
