#!/usr/bin/env python

import sys
from subprocess import Popen, PIPE
import logging
import re
import yaml


def die(msg, exit_code=1):
    logging.error(msg)
    sys.exit(exit_code)


def getpools():
    p = Popen("zpool list -Ho name,health", shell=True, stdout=PIPE)
    zpools = {a.split('\t')[0]: a.split('\t')[1] for a in p.communicate()[0].splitlines()}
    if zpools:
        return zpools
    else:
        die("Can't get zfs pools")


def getpoolinfo(pool):
    p = Popen("zpool status "+pool, shell=True, stdout=PIPE)
    zpool_status = p.communicate()[0]
    out=''
    previous_line = ''
    tabs = 0
    for line in zpool_status.splitlines():        
        if line == '':
            continue
        if line.startswith('\t'):
            if previous_line.startswith(('action', 'status', 'invalid', '\tusing', '\tconfig', 'scan')):
                line = line.strip()
                out = out.strip()
                out += line +'\n'
                previous_line = line
                continue
            if line.startswith('\tNAME'):
                continue
            if line.startswith('\t'+pool):
                continue
            m = re.search('(\t)(\s*)([\w-]*)(\s*)(\w*)([\w\s()]*)', line)
            if not m.group(3).startswith(('raidz', 'mirror', 'replacing')):
                line = m.group(2) + m.group(3) + ':' + (' ' if m.group(5) else '') + m.group(5) # (m.group(5) if m.group(5) != 'ONLINE' else '')
            else:
                line = m.group(2) + m.group(3) + ':' + (' ' if m.group(5) else '') + '\n' + m.group(2) + '  ' + 'state: ' + m.group(5)
            if m.group(6).find('resilvering') != -1:
                line = m.group(2) + m.group(3) + ': ' + 'resilve' 
        else:
            line = line.lstrip()
        if line.find('resilvered') >0 and line.find('done') > 0:
            out = out[:-len(previous_line)]
            line = 'resilvering: ' + previous_line + ', ' + line.strip()
        previous_line = line
        out += line + '\n'
    info = yaml.load(out)
    return info


def check_replace_possibility(pool_info, disk):
#    print(pool_info)
    for array, disks in pool_info.get('config').items():
        print(disks.keys(), disks.get('state'), disk)
        if any(disk in parts for parts in disks.keys()):
            if disks.get('state') == 'ONLINE':
                return True
            else:
                return False
        else:
            continue
    return False


if __name__ == '__main__':
    if sys.argv[1]:
        FAIL_DISK = sys.argv[1].split('/')[-1]
#        if sys.argv[1].startswith('/dev'):
#            FAIL_DISK = sys.argv[1].split('/')[-1]
#        else:
#            FAIL_DISK = sys.argv[1]
    pools = getpools()
    for pool, health in pools.items():
        pool_info = getpoolinfo(pool)
        if not check_replace_possibility(pool_info, FAIL_DISK):
#            print('NO')
            exit(101)

