#!/usr/bin/python
# -*- coding: utf8 -*-

import requests
import re
import time
import graphitesend


JUGGLER_HOST_PREFIX = u'direct.logpusher-stat'
HOST = '127.0.0.1'
PORT = 42000
PREFIX = 'direct_one_min.global.juggler'

selections = [
                 {
                    'url': 'https://observatorium.common.yandex.ru/juggler/ce/?format=graphite&project=direct&check_tag=%2Bdirectadmin_TV',
                    'name': 'tag_directadmin_TV'
                 }
             ]


def get_data(url):
    data = requests.get(url, verify=False).json()
    data['total'] = data['OK'] + data['WARN'] + data['CRIT']
    del data['OK']
    return data


def write_to_graphite(data):
    gsender = graphitesend.init(graphite_server=HOST, graphite_port=PORT, system_name='', prefix=PREFIX)
    gsender.send_list(data, timestamp=int(time.time()))
    time.sleep(0.1)


def prepare_data_for_graphite(data, selection):
    data_graphite = []

    for key in data:
        data_graphite.append(["%s.%s" % (selection['name'].replace('.', '_'), key.replace('.', '_')), data[key]])

    return data_graphite


def run():
    for selection in selections:
        data = get_data(selection['url'])
        data_for_graphite = prepare_data_for_graphite(data, selection)
        write_to_graphite(data_for_graphite)


if __name__ == "__main__":
    run()
