#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Скрипт для забора статистики телефонных звонков и складывания ее посуточно в графит
"""

import hashlib
from urllib import urlencode 
from os import chdir, mkdir, path
import urllib2
import json
import datetime
from datetime import datetime as dt, date as dd
import time
import sys
import getopt
import logging
import socket
import yaml
from functools import wraps

def die(msg, exit_code=1):
    logging.error(msg)
    sys.exit(exit_code)


def retry(ExceptionToCheck, tries=3, delay=3, backoff=2):
    """Retry calling the decorated function using an exponential backoff.
        http://wiki.python.org/moin/PythonDecoratorLibrary#Retry"""
    def deco_retry(f):
        @wraps(f)
        def f_retry(*args, **kwargs):
            mtries, mdelay = tries, delay
            while mtries >= 1:
                try:
                    return f(*args, **kwargs)
                except ExceptionToCheck, e:
                    time.sleep(mdelay)
                    mtries -= 1
                    mdelay *= backoff
                else:
                    return f(*args, **kwargs)
            die(str(e))   
        return f_retry
    return deco_retry


def checknight(checktime, startnight, endnight):
    midday = 43200
    #if type(timestmp) != int: 
    #    timestmp = int(timestmp)
    hour = checktime.hour
    if hour>startnight or hour<endnight:
        return True
    else:
        return False


def datespan(start_date, end_date, entity):
    if entity == "months":
        delta=datetime.timedelta(days=30)
    elif entity == "days":
        delta=datetime.timedelta(days=1)
    currentDate = start_date
    endDate = end_date
    while currentDate <= endDate:
        yield currentDate.date()
        if datetime.timedelta(0) < endDate - currentDate < delta:
            currentDate = endDate
        else:
            currentDate += delta


def save_to_file(data, filename):    #для дебага или сохранения ответа
    with open(filename,'w') as f:
        data = json.dump(data, f, ensure_ascii=True)
    return True

def load_from_file(filename):    #для дебага или загрузки уже имеющегося ответа
    with open(filename,'r') as f:
        data = json.load(f)
    return data

@retry((IOError), tries=3, delay=10, backoff=2)
def send_data_to_graphite(graphite_host, graphite_port, messages):
    s = socket.create_connection((graphite_host, graphite_port))
    s.sendall(messages)
    s.close()

@retry((urllib2.HTTPError), tries=4, delay=10, backoff=2)
def req_from_nocapi(start_timestmp, end_timestmp, robot_name, phone, key):
    api_host = 'https://tel.yandex-team.ru/robot.php/?/mod.cipt-stat/api&'
    #api_host = 'https://127.0.0.1/api&' #- test only
    myreq = dict(SECTION="INTERNAL",DIRECTION="IORIG",TIMERANGE={"START":start_timestmp,"END":end_timestmp},TYPE="LIST",NUMLIST={"TYPE":"LIST","DATA":phone})
    req = json.dumps(myreq)
    host_name = socket.getfqdn()
    token = u'/mod.cipt-stat/api&request=%s&dauth=%s&dhost=%s%s' % ( req, robot_name, host_name, key)
    #print(token)
    sign = hashlib.sha1()
    sign.update(token)
    auth = '&dauth=%s&dhost=%s&dsign=%s' % ( robot_name, host_name, sign.hexdigest() )
    req_en = urlencode({"request": req})
    request = api_host + req_en + auth
    response = urllib2.urlopen(request)
    data = response.read()
    return data


def callstat_from_noc(start_date, end_date, robot_name, phone_number, auth_key):
    monitor_month=[]
    monitor_days_call = {i:[0,0,0] for i in datespan(start_date, end_date, "days")}
    if end_date > start_date + datetime.timedelta(days=30):
        monitor_month = sorted({i for i in datespan(start_date, end_date, "months")})
    else:
        monitor_month = [start_date, end_date]
    for i in range(len(monitor_month)-1):
        startdate = time.mktime(monitor_month[i].timetuple())
        enddate = time.mktime(monitor_month[i+1].timetuple())
        logging.info("Get info from %s to %s" % (monitor_month[i], monitor_month[i+1]))
        #jsondata = load_from_file("%s-%s.json" % (start_timestmp, end_timestmp))
        data = req_from_nocapi(startdate, enddate, robot_name, phone_number, auth_key)
        jsondata = json.loads(data)["DATA"]
        if not jsondata:
            logging.error("No data from NOC")
            continue
        #savetofile(jsondata, '%s-%s.json' % (start_timestmp, end_timestmp))
        for key,value in jsondata.items():
            if int(value[u"DURATION"]) <= 0:
                continue
            date_from_noc = dt.fromtimestamp(int(value[u"TIMEORIG"]))
            #phone = (int(value[u"CALLEDFINAL"]))
            monitor_days_call[date_from_noc.date()][0] += 1
            if checknight(date_from_noc, startnight, endnight):
                monitor_days_call[date_from_noc.date()][2] += 1
            else:
                monitor_days_call[date_from_noc.date()][1] += 1
    return monitor_days_call


def write_new_date(last_date):
    start_today = (dd.today() + datetime.timedelta(days = 1)).strftime("%Y-%m-%d %H:%M:%S")
    with open('tel', 'w') as f:
        f.write(last_date.strftime("%Y-%m-%d %H:%M:%S")+"\n")
        f.write(start_today + "\n")


def get_date_from_file(filename):
    yesterday = dt.now() - datetime.timedelta(days=1)
    yesterday_begin = dt(yesterday.year, yesterday.month, yesterday.day,0,0,0,0)
    today = dt.today()
    today_begin = dt(today.year, today.month, today.day,0,0,0,0)
    try:
        with open(filename, 'r') as f:
            #spane_bordr = [next(f).strip() for x in xrange(2)]
            spane_bordr = []
            for line in f:
                spane_bordr.append(line.strip())
        start_date = dt.strptime(spane_bordr[0], "%Y-%m-%d %H:%M:%S")
        end_date = dt.strptime(spane_bordr[1], "%Y-%m-%d %H:%M:%S")
    except IOError as e:
        logging.error("Can't read config file, use last day")
        start_date = yesterday_begin
        end_date = today_begin
    except (IndexError, ValueError) as e:
        logging.error("Can't parse conf file")
        if 'start_date' not in globals():
            start_date = yesterday_begin
        end_date = today_begin
    finally:
        logging.info("Use spane from %s to %s" % (start_date, end_date))
    if dt.today() < start_date:
        die("Can't get info from future ;-) . Exit")
    return (start_date, end_date)


def get_date_from_graphite(graphite_balancer, table):
    req_fields = ["target", "from", "until", "format"]
    myreq = {x:"" for x in req_fields}
    myreq["target"] = "one_min.%s.calls" % table
    myreq["from"] = "-1years"
    myreq["until"] = "now"
    myreq["format"] = "json"
    req_qer = urlencode(myreq)
    req_host = "http://" + graphite_balancer + "/render/?"
    ans = urllib2.urlopen(req_host + req_qer).read()
    answer = json.loads(ans)
    timestamps = []
    for item in answer[0]["datapoints"]:
        if item[0] == None:
            continue
        timestamps.append(int(item[1]))
    if len(timestamps) > 0:
        last_timestmp = max(timestamps)
        start_date = dt.fromtimestamp(last_timestmp) + datetime.timedelta(days=1)
    else:
        start_date = dt.now() - datetime.timedelta(days=1)
    return (start_date, dt.now())


if __name__ == '__main__':
    conffile = '/etc/yandex-du-monitoring-count/tel.conf'

    if not path.exists('/var/log/mon-count'):
        mkdir('/var/log/mon-count')
    logfile = '/var/log/mon-count/log.tel.%s' % dt.now().date().strftime("%Y%m")
    if 'debug' in sys.argv[1:]:
        logging.basicConfig(format = '%(levelname)-8s [%(asctime)s] %(message)s',level = logging.DEBUG,stream = sys.stdout)
    else:
        logging.basicConfig(format = '%(levelname)-8s [%(asctime)s] %(message)s',level = logging.DEBUG,filename = logfile)

    logging.info("Try to read config")
    try:
        with open(conffile, 'r') as cfg_file:
            cfg = yaml.load(cfg_file)
    except IOError as e:
        die("Can't open config file %s. Error: %s" % (conffile, e.strerror))
    except yaml.YAMLError as e:
        die("Can't parse config file %s. Error: %s" % (conffile, str(e).replace("\n", " "))) 
    startnight = cfg["startnight"]
    endnight = cfg["endnight"]
    robot_name = cfg["robot_name"]
    phone_number = cfg["phone_number"]
    auth_key = cfg["auth_key"]
    graphite_host = cfg["graphite_host"]
    graphite_port = cfg["graphite_port"]
    graphite_balancer = cfg["graphite_balancer"]
    table = cfg["graphite_node"]
    workdir = '/var/cache/yandex-du-monitoring-count'
    try:
        chdir(workdir)
    except OSError:
        mkdir(workdir)
        chdir(workdir)
    logging.info("---" * 10 + "Start" + "---" * 10)

    if not path.exists('/var/log/mon-count'):
        mkdir('/var/log/mon-count')
    workdir = '/var/cache/yandex-du-monitoring-count'
    try:
        chdir(workdir)
    except OSError:
        mkdir(workdir)
        chdir(workdir)
    #start_date, end_date = get_date_from_file('tel')
    start_date, end_date = get_date_from_graphite(graphite_balancer, table)
    logging.info("Get info from %s to %s" % (start_date, end_date))
    logging.info("Start getting info from noc")
    call_data = callstat_from_noc(start_date, end_date, robot_name, phone_number, auth_key)
    logging.info("Writing data to graphite")
    for key,value in sorted(call_data.items()):
        result_all = '%s.%s.%s %d %.0f' % ("one_min", table, "calls", value[0], time.mktime(key.timetuple()) )
        result_day = '%s.%s.%s %d %.0f' % ("one_min", table, "calls_day", value[1], time.mktime(key.timetuple()) )
        result_night = '%s.%s.%s %d %.0f' % ("one_min", table, "calls_night", value[2], time.mktime(key.timetuple()) )
        result = "\n".join([result_all, result_day, result_night])
        send_data_to_graphite(graphite_host, graphite_port, result)
        #print(str(key) + " - " + str(value))
    logging.info("---" * 10 + "End" + "---" * 10)
