#!/usr/bin/perl
use strict;
use warnings;
use File::Copy;
use File::Path qw(remove_tree);
use Pid::File::Flock;
Pid::File::Flock->new();

sub log_msg {
  my $date = qx(date);
  print "$date @_\n";
}

my $retention = $ARGV[0];
my $backup_dir = $ARGV[1];
die "Usage: $0 retention base_backup_dir (like /local/backup/rsnap/mysql)" if not $backup_dir or not $retention;
$backup_dir =~ s|/$||;

opendir(my $dh, $backup_dir) or die "can't open $backup_dir";
while(readdir $dh) {
  /^\.+$/ && next;
  my $instance = $_;
  my $inst_dir = "$backup_dir/$_";
  -f "$inst_dir/tmp/.rsnap_prot0" or next;
  log_msg("$instance: found $inst_dir/tmp/.rsnap_prot0, try to rotate...");

  opendir(my $inst_tmp_dh, "$inst_dir/tmp") or next;
  opendir(my $inst_dh, "$inst_dir") or next; 
  my @to_rotate = sort {$b <=> $a } grep /^\d+$/, readdir $inst_dh;
 
  if (@to_rotate > $retention) {
    log_msg("remove $inst_dir/$to_rotate[0] ...");
    remove_tree("$inst_dir/$to_rotate[0]");
    shift @to_rotate;
  }
  map { log_msg("move $inst_dir/$_ ..."); move("$inst_dir/$_", sprintf("$inst_dir/%04d", $_ + 1)) } @to_rotate;
  log_msg("move tmp to $inst_dir/0000 ...");
  move("$inst_dir/tmp", "$inst_dir/0000");
  log_msg("$instance: successfully rotated");
}
