#!/bin/bash

REALFILE=/etc/mysql/graphite.conf.d/wsrep.cnf

if [ ! -e $REALFILE ]; then
    echo "2;$REALFILE doesn't exist"
    exit 0
fi

TEMPFILE=$(mktemp)

GENERATE_CMD="/usr/local/bin/generate-mysql-wsrep-cnf.pl
    --instance=graphite
    --cgroup=ppcgraphitev6
    --galera-port=17411
    --template=/etc/mysql/graphite-wsrep.cnf.tmpl
    --outfile=$TEMPFILE"

if ! $GENERATE_CMD; then
    echo "1;$GENERATE_CMD failed"
    exit 0
fi

if ! cmp -s $TEMPFILE $REALFILE; then
    echo "2;$REALFILE doesn't match the generated config ($TEMPFILE)"
    exit 0
fi

echo "0;OK"
exit 0

