#!/usr/bin/env python2
# -*- encoding: utf-8 -*-

import cmysql
import re
import time

head = '''Проверяет разницу времени отставания репликации slave и master. Скрипт mysqlGenerateHeartbeat.py запускается на ppcback* серверах, генерирует значение timestamp и записывает его в heartbeat.heartbeat мастер БД. Текущий скрипт сравнивает разницу между текущим временем и временем, записанным в таблице. Если heartbeat.heartbeat не существует, считаем, что проверка на шардах не работает и это норма.
'''

DELTA = 600 #отствание не более 10 минут

def run(config, **kwargs):
    requests1 = { 'master_timestamp': "select timestamp from heartbeat.heartbeat",
    }

    results = cmysql.query(requests1, config)
    errors = [ '[{0}] {1}'.format(i, results[i][1]) for i in results if results[i][1] ]
    if len(errors) != 0:
        return (0, 'INFO. Table heartbeat.heartbeat doesn\'t exist. Disable check', __name__)

    master_timestamp = int(results['master_timestamp'][0][0][0])
    current_timestamp = int(time.time())
    diff_time = current_timestamp-master_timestamp

    if diff_time>DELTA:
        msg = 'FAILED. Big replication lag: {0}s'.format(diff_time)
        return (2, msg, __name__)

    msg = 'SUCCESS. No replication lag: {0}s'.format(diff_time)
    return (0, msg, __name__)

def help():
    return head
