
# см. https://www.percona.com/doc/percona-toolkit/LATEST/pt-kill.html#cmdoption-pt-kill-filter
# pt-kill имеет три параметра, сочетание которых имеет значение для этих правил:
# --filter, --busy-time, --internal
# сначала, все увиденные pt-kill'ом запросы проходят этот фильтр, он указывается в параметре --filter
# далее, если в оставшихся время будет больше --busy-time, то запрос прибивается
# интервал проверок задаётся с помощью --interval, если он не задан, вродебы берётся половина --busy-time

# запросы, не попадающие под эти правила не пройдут фильтр, следовательно никогда не будут прибиты pt-kill'ом
my @queries_to_filter = (
    {
        'regexp' => '\/\* +reqid:[0-9]+:direct\.script:bsClientData.*\*\/',
        'time' => 1800,
    },
    {
        'regexp' => '\/\* +reqid:[0-9]+:direct\.script:moderateExportMaster.*\*\/',
        'time' => 1200,
    },
    {
	    'regexp' => '\/\* +reqid:[0-9]+:direct\.script.*\*\/',
        'time' => 10800,
    },
    {
	    'regexp' => '\/\* +reqid:[0-9]+:direct\.(json-api|web|api5).*\*\/',
        'time' => 300,
    },
    {
	    'regexp' => '\/\* +pt-kill-me .*\*\/',
        'time' => 0,
    },
);

my $continue_processing = 0;

if ($event->{Command} ne 'Sleep') {
    for my $query (@queries_to_filter) {
        if (defined($event->{Info}) && $event->{Info} =~ m!$query->{regexp}!) {
            if ($event->{Time} >= $query->{time}) {
                $continue_processing = 1;
                #print STDERR Data::Dumper::Dumper($event);
            }
            last;
        }
    }
}
$continue_processing
