#!/usr/bin/env python
# *-* encoding: utf-8 *-*

import logging
import os
import optparse
import sys

PID_FILE = '/etc/sv/ptkill-ppcdata/supervise/pid'

def getLogSetup(level):
    logger = logging.getLogger('steam logs to console')
    logger.setLevel(level=getattr(logging, level))
    ch = logging.StreamHandler()
    ch.setLevel(level=getattr(logging, level))
    if level.upper() == 'DEBUG':
        formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
    else:
        formatter = logging.Formatter('%(message)s')
    ch.setFormatter(formatter)
    logger.addHandler(ch)
    return logger

def checkPtKill(pid_file):
    ''' Ищем активные процессы ptkill в sv, читаем его pid и проверяем его
        наличие в /proc. False - все плохо, True - процесс жив.
    '''
    logger.debug(pid_file)
    if not os.path.exists(pid_file):
        return False
    with open(pid_file, 'r') as fd:
        pid = fd.read()
    if not pid:
        return False
    proc_file = '/proc/{0}/stat'.format(pid.strip())
    logger.debug(proc_file)
    if not os.path.exists(proc_file):
        return False
    return True

def checkMysql():
    ''' Если ptkill мерт, то не стоит зажигать проверку при отсутствии живого mysqld.
        Ищем любую живность на сервере, если ничего не найдено, то зажигаться проверка 
        не должна. False - mysql мертв, True - жив.
    '''
    mysql_dirs = [ i for i in os.listdir('/run') if i.startswith('mysqld.ppcdata') ]
    logger.debug(mysql_dirs)
    mysql_pid_files = [ '/run/{0}/mysqld.pid'.format(i) for i in mysql_dirs ]
    logger.debug(mysql_pid_files)
    mysql_pids = [ open(i).read().strip() for i in mysql_pid_files if os.path.exists(i) ]
    if len(mysql_pids) == 0:
        return False
    logger.debug(mysql_pids)
    mysql_stats = [ os.path.exists('/proc/{0}/stat'.format(i)) for i in mysql_pids ]
    logger.debug(mysql_stats)
    return any(mysql_stats)

def main(opts):
    global logger
    if opts.debug:
        logger = getLogSetup('DEBUG')
    else:
        logger = getLogSetup('INFO')
    status = checkPtKill(PID_FILE)
    if status:
        logger.info('0; pt-kill alive')
    elif checkMysql():
        logger.info('2; pt-kill died')
    else:
        logger.info('1; MySQLd died, pt-kill dont working')

if __name__ == '__main__':


    usage = "usage: {0}".format(sys.argv[0])
    parser = optparse.OptionParser(usage=usage)
    parser.add_option("-d", "--debug",
                      action="store_true", dest="debug",
                      help="run debug mode(default: False)"
    )
    (opts, args) = parser.parse_args()

    main(opts)
