#!/usr/bin/python
# -*- coding: utf-8 -*-
# vim: set expandtab:tabstop=4:softtabstop=4:shiftwidth=4:nowrap
# $Id$

import argparse
import errno
import logging
import os
import subprocess
import sys

run_script_tmpl = u'''#!/bin/bash
# generated by {script_name}

instance={instance_name}
#exec /usr/bin/pt-kill -S /var/run/mysqld."$instance"/mysqld.sock -D 'ppc' --busy-time 300 --match-host 'ppcsoap.*|ci.*' --ignore-command '^Sleep$' --$(cat /etc/ptkill/action 2>/dev/null || echo print) --victims all >> /var/log/mysql."$instance"/ptkill-query.log

## --kill-query --print -- print & kill
exec chpst -m 1073741824 /usr/bin/pt-kill -S /var/run/mysqld."$instance"/mysqld.sock -D 'ppc' --filter /etc/ptkill/ppcdata.pl --busy-time 30 --ignore-command '^Sleep$' --kill-query --print --victims all >> /var/log/mysql."$instance"/ptkill-query.log

## --print -- print only
#exec chpst -m 1073741824 /usr/bin/pt-kill -S /var/run/mysqld."$instance"/mysqld.sock -D 'ppc' --filter /etc/ptkill/ppcdata.pl --busy-time 30 --ignore-command '^Sleep$' --print --victims all >> /var/log/mysql."$instance"/ptkill-query.log

#TODO  умирать, если пустой инстанс
'''


def run():
    script_name = os.path.basename(__file__)
    desc = u'''сгенерировать и (пере)запустить конфиги sv-сервисов ptkill

Пример:
    {script_name} ppcdata18 ppcdata19
    # сгенерировать на всех ppcdata на этой машине
    lm --complete | grep ^ppcdata | xargs {script_name}

'''.format(script_name=script_name)
    parser = argparse.ArgumentParser(description=desc, formatter_class=argparse.RawDescriptionHelpFormatter)
    parser.add_argument('instances', metavar='instance', nargs='+', help=u'инстанс mysql, например, ppcdata1')
    parser.add_argument('--verbose', '-v', action='store_true')
    args = parser.parse_args()
    instances = sys.argv[1:]
    logging_level = logging.INFO
    if 'verbose' in args and args.verbose:
        logging_level = logging.DEBUG
    logging.basicConfig(level=logging_level, format='%(message)s')
    instances = args.instances
    for inst in instances:
        logging.debug('creating service for %s' % inst)
        service_name = 'ptkill-%s' % inst
        sv_dir = '/etc/sv/%s' % service_name
        run_file = sv_dir + '/run'
        try:
            logging.debug('creating directory %s' % sv_dir)
            os.makedirs(sv_dir)
        except OSError as e:
            if e.errno == errno.EEXIST:
                pass
            else:
                raise
        logging.debug('writing file %s' % run_file)
        with open(run_file, 'w+') as f:
            run_script_text = run_script_tmpl.format(script_name=script_name, instance_name=inst)
            f.write(run_script_text.encode('utf-8'))
            logging.debug('setting exec permissions on file %s' % run_file)
        os.chmod(run_file, 0755)
        service_exists = (subprocess.call(['update-service', '--check', service_name]) == 0)
        if not service_exists:
            subprocess.check_call(['update-service', '--add', sv_dir])
        else:
            subprocess.call(['sv', '-w', '10', 'term', service_name])


if __name__ == '__main__':
    run()
