#!/usr/bin/perl
use strict;
use warnings;
use utf8;

=head1 NAME

    umount-remote-log-rfs.pl

=head1 SYNOPSIS

    без параметров
    руками (без лока) лучше не запускать

=head1 DESCRIPTION

    Скрипт отвечает за полное размонтирование всех remotefs-логов с текущего сервера

=cut

use File::Path;
use Yandex::Log;
use Yandex::Shell;
use POSIX qw(strftime);

my $CMD_FILTER = q{ 2>&1 | perl -MPOSIX=strftime -npe 'print strftime("%Y-%m-%d\\t%H:%M:%S\\t", localtime)' };
my $MOUNT_BASE = '/mnt/remote-log-rfs';
$Yandex::Log::LOG_ROOT = '/var/log/remote-log-client-rfs';

run() unless caller();

sub run {
    my $log = Yandex::Log->new(log_file_name => 'umount.log', date_suf => '%Y%m%d');
    my $cmd_log = "$Yandex::Log::LOG_ROOT/umount-commands.log.".strftime('%Y%m%d', localtime);
    $log->out('start');

    my @m_dirs = grep {/^$MOUNT_BASE/} map {/on (.+) type fuse/} split "\n", yash_qx("mount");

    for my $m_dir (@m_dirs) {
        my $code;
        for my $i (1..5) {
            $code = system("umount $m_dir $CMD_FILTER >> $cmd_log");
            last if $code == 0;
            sleep(2);
        }
        
        $code = system("rm -rf $m_dir $CMD_FILTER >> $cmd_log") if $code == 0;

        if ($code == 0) {
            $log->out("SUCCESS: $m_dir was removed");
        } else {
            $log->out("ERROR: can't remove $m_dir");
        }
    }

    if (system("rm -rf $MOUNT_BASE/* $CMD_FILTER >> $cmd_log") == 0) {
        $log->out("SUCCESS: other dirs in $MOUNT_BASE were removed");
    } else {
        $log->out("ERROR: can't remove other dirs in $MOUNT_BASE");
    }

    $log->out('finish');
    return 0;
}

