#!/bin/bash

# depends: procmail, # postfix

# defining message file
rmail_file='/var/mail/root'

if [[ $(formail -v > /dev/null 2>&1; echo "$?") -ne 64 ]]; then
    echo 'Install procmail! Quiting...' >&2
    exit 1
fi

default_checks()
{
# doing some checks
if [ ! -e "$rmail_file" ]; then
    echo 'No root mail messages.'
    exit 0
elif [ -e "$rmail_file".processing ]; then
    echo -e "There are mail messages (${rmail_file}.processing) in processing state.\nTry: $(basename $0) resend" >&2
    exit 1
elif [ $(wc -c "$rmail_file" | cut -d" " -f1) -eq 0 ]; then
    echo 'Empty root mail file.'
    exit 0
fi
}


move_rmail_file()
{
# preventing append new mail
mv "$rmail_file" "$rmail_file".processing
}


prepare_to_split()
{
# preparing to split mail file
mkdir "$rmail_file".splitted 2> /dev/null
if [ "$(ls -A ${rmail_file}.splitted)" ]; then
    echo -e "There are mail messages (in dir: ${rmail_file}.splitted) in processing/splitted state.\nTry: $(basename $0) resend" >&2
    exit 1
fi
}


split()
{
# splitting file and removing .processing-file
if cat "$rmail_file".processing | formail -ds sh -c "cat > $rmail_file.splitted/msg.\$FILENO"; then
    rm -f "$rmail_file".processing
else
    rm -f "$rmail_file.splitted"/*
    echo "Mail splitting failed." >&2
    exit 1
fi
}


send()
{
# resending e-mail messages one be one and deleting sent messages
counter=0
for message in $(ls "$rmail_file".splitted); do
    counter=$(($counter + 1))

    # get subject:
    subject=$(formail -X Subject: -t < "$rmail_file".splitted/"$message" 2> /dev/null)
    # set subject:
    subject="${subject} [**resent from local root mail**]"

    formail -I Delivered-To: -t < "$rmail_file".splitted/"$message" | formail -I "$subject" -s /usr/sbin/sendmail -t && rm -f "$rmail_file".splitted/"$message"
#    formail -I Delivered-To: -s /usr/sbin/sendmail -oi -t < "$rmail_file".splitted/"$message" && rm -f "$rmail_file".splitted/"$message"

    if [ "$ignore" != "true" ]; then
	if [[ $(($counter % 5)) -eq 0 ]]; then
	    if mail -e -f "$rmail_file" 2> /dev/null; then
		echo -e "Seems like messages are being redelivered back to $rmail_file. Fix your mailer and try again: $(basename $0) resend" >&2
		exit 1
	    fi
	    # if you don't want to be banned
	    #	sleep 1
	fi
    fi
done
}


check_sent()
{
# checking for fails in previous for loop
if [ "$(ls -A ${rmail_file}.splitted)" ]; then
    echo -e "Some messages (in dir: ${rmail_file}.splitted) were not delivered.\nTry: $(basename $0) resend" >&2
    exit 2
else
    rmdir "$rmail_file".splitted
fi
}


remove_splitted()
{
    rm -f "$rmail_file".splitted/*
}


resend()
{
    if [ -e "$rmail_file".processing -a ! -e "$rmail_file".splitted ]; then
	prepare_to_split
	split
	send
	check_sent
	exit 0
    elif [ ! -e "$rmail_file".processing -a -e "$rmail_file".splitted ]; then
	send
	check_sent
	exit 0
    elif [ -e "$rmail_file".processing -a -e "$rmail_file".splitted ]; then
	remove_splitted
	split
	send
	check_sent
	exit 0
    else
	echo "Nothing to resend."
	exit 0
    fi
}


case "$1" in
    '')
	default_checks
	move_rmail_file
	prepare_to_split
	split
	send
	check_sent
	exit 0
    ;;
    resend)
	echo "Warning: in this mode we don't check messages for being redelivered back into $rmail_file. Check it by yourself."
	ignore="true"
	resend
	exit 0
    ;;
    *)
	echo "Wrong usage. Try: $(basename $0) [resend]" >&2
	exit 1
    ;;
esac


exit 0

