#!/usr/bin/env python

import socket

def to_ip(hostnames):
    hostsip = []
    for hostname in hostnames:
        ip6adr = socket.getaddrinfo(hostname, None, socket.AF_INET6)[0][4][0]
        hostsip.append(ip6adr)
        ip4adr = socket.getaddrinfo(hostname, None, socket.AF_INET)[0][4][0]
        hostsip.append(ip4adr)
    return  hostsip

class FilterModule(object):
     def filters(self):
         return {'to_ip': to_ip}

