#!/usr/bin/python
# *-* encoding: utf-8 *-*

import os
import yaml
import fcntl
import socket
import urllib2
import optparse
import shutil
from subprocess import Popen, PIPE
import requests
from requests.packages.urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

FILE_CONFIG = '/etc/group-grants'
CONDUCTOR_URL = 'http://c.yandex-team.ru/api/'
ABC_API_URL = 'https://abc-back.yandex-team.ru/api/v4/'
ABC_TOKEN_PATH = '/etc/direct-tokens/startrek'
ABC_TOKEN = ''

with open(ABC_TOKEN_PATH, 'r') as token_file:
    ABC_TOKEN = token_file.read().strip()

''' Программа для генерирования и добавления списка пользователей в
    определенные группы на основе их нахождения в ABC, staff и POSIX группaх.
    Скрипт полностью заменяет строку, поэтому если в группе присутствуют
    другие пользователи не определенные в GROUPS, их следует добавить в USERS или указать проект в ABC.
    У ABC следующий формат записей: project_slug.project_role (например, direct.developer).
    По умолчанию конфигурационный файл живет в FILE_CONFIG=/etc/group-grants.
    Меняются только те строки, которые указаны в GROUPS или USERS. Остальные
    записи в /etc/group остаются без изменений.
'''


def get_request(address):
    request = urllib2.urlopen(address, timeout=20)
    result = request.read().rstrip('\n').split('\n')
    return result

def c_hosts2groups(host):
    handler = '/'.join([CONDUCTOR_URL, 'hosts2groups', host])
    return get_request(handler)

def update_dicts(dict_result, dict_begin):
    ''' Принимает два хеша. Первый - который обновить, второй - обновляющий.
    '''
    for _type in dict_begin:
        for _group in dict_begin[_type]:
            dict_result[_type].setdefault(_group, []) # Создаем пустой список, если его нет
            dict_result[_type][_group].extend(dict_begin[_type][_group])

def readYamlFile(file_yaml):
    ''' Читаем yaml конфиг и выводимхеш формата:
        >>> {'GROUPS': [...], 'USERS': [...], 'ABC': [...]}
    '''
    result = {'GROUPS': {}, 'USERS': {}, 'ABC': {}}
    hostname = socket.getfqdn()
    try:
        with open(file_yaml, 'rb') as _file:
            dict_yaml = yaml.load(_file)
    except Exception as e:
        print str(e)
        raise SystemExit
    [ update_dicts(result, dict_yaml[_key]) for _key in dict_yaml
                                            if _key.count('conductor') and
                                            _key.split('.', 1)[1] in c_hosts2groups(hostname)]
    [ update_dicts(result, dict_yaml[_key]) for _key in dict_yaml
                                            if _key == hostname ]
    return result

def getUsersInGroup(groups):
    ''' Получаем список пользователей групп. На входе принимает список групп.
        На выходе отдает список пользователей.
        Пример:
            >>> admins = getUsersInGroup('serveradmins')
            >>> print admins
                ['rivik','dspushkin','guba','civil','velom','frenz']
    '''
    result = list()
    for group in groups:
        tmp = Popen(['getent', 'group', group], stdout=PIPE, stderr=PIPE)
        buff = tmp.stdout.read().rstrip().split(':')[-1].split(',')
        if buff: result.extend(buff)
    return result


def getUsersInABC(entries):
    ''' Получаем список пользователей из проектов в ABC с нужными ролями '''

    result = []
    for entry in entries:
        try:
            slug, role = entry.split('.')
            req = requests.get(
                "%sservices/members/" % ABC_API_URL,
                params={'fields': 'person.login', 'page_size': '1000', 'service__slug': slug, 'role__code': role},
                headers={'Authorization': 'OAuth %s' % ABC_TOKEN},
                verify=False
            )

            data = req.json()
            result.extend([el['person']['login'] for el in data['results']])

        except:
            pass

    return result


def genUnixGroup(group_dicts, user_dicts, abc_dicts, group_path='/etc/group'):
    ''' Функция на основе словарей генерирует /etc/group.tmp файл,
        который впоследствии заменяет /etc/group. Меняются только строки
        с группами указанными в словаре group_dicts или user_dicts.
        Старый файл сохраняется с именем /etc/group.bak. Функция не
        возвращает ответа.
        Пример 1:
           >>> GROUPS = { 'sudo': ['serveradmins',] }
           >>> USERS = { 'sudo': ['lena-san',] }
           >>> genUnixGroup(GROUPS,USERS)
           В итоге в /etc/groups будет изменена только строка sudo:
               sudo:x:27:lena-san,rivik,dspushkin,guba,civil,velom,frenz
        Пример 2:
           >>> GROUPS = { 'sudo': ['serveradmins',] }
           >>> USERS = { 'ppc': ['lena-san',] }
           >>> genUnixGroup(GROUPS,USERS)
               sudo:x:27:rivik,dspushkin,guba,civil,velom,frenz
               pps:x:9000:lena-san
    '''
    warn_msg = '# Этот список сгенерирован скриптом add_group_users.py. Все ручные правки будут уничтожены!\n'
    with open(group_path) as gfile:
        lock = fcntl.flock(gfile, fcntl.LOCK_EX | fcntl.LOCK_NB)
        unix_list = gfile.readlines()
        unix_list = [ i for i in unix_list if not i.startswith('# ') ] # Удаляем старые комментарии
        unix_dict = {entry[:entry.find(':')]: entry for entry in unix_list if entry.find(':') != -1}
        global_list = set(group_dicts.keys()) | set(user_dicts.keys()) | set(abc_dicts.keys()) # Общий список групп

        for group in global_list:
            result = user_dicts.get(group,list()) # Добавляем юзеров, что не в группах
            result.extend(getUsersInGroup(group_dicts.get(group,list()))) # Добавляем списки людей в группах
            result.extend(getUsersInABC(abc_dicts.get(group, list()))) # добавляем пользователей из проектов в ABC

            result = list(set(result))
            result = ','.join([ val for val in result if val ]) # Убираем пустышки.
            result = result + '\n' # Конец строки обязателен.

            if group in unix_dict:
                header = ':'.join(unix_dict[group].split(':')[:-1])
                unix_dict[group] = ':'.join([header, result])

        with open(group_path + '.tmp', 'w') as gfile:
            gfile.write(warn_msg)
            gfile.writelines(sorted(unix_dict.values()))
            gfile.write(warn_msg)
        if opts.try_script and os.path.exists(group_path + '.tmp'):
            shutil.copyfile(group_path, group_path + '.bak')
            os.rename(group_path + '.tmp', group_path)

if __name__ == '__main__':

    usage = "usage: add-group-users.py"
    parser = optparse.OptionParser(usage=usage)
    parser.add_option( "-f", "--file", action="store", dest="file_config", default=FILE_CONFIG,
                      help="Configuration grants file. Ex. --file=/etc/group-grants")
    parser.add_option( "-t", "--try", action="store_false", dest="try_script", default=True,
                      help="Dont change /etc/group. Only create /etc/group.tmp")
    (opts, args) = parser.parse_args()

    config_dict = readYamlFile(opts.file_config)
    genUnixGroup(config_dict.get('GROUPS', dict()),
                 config_dict.get('USERS', dict()),
                 config_dict.get('ABC', dict()))
