#!/usr/bin/python
# -*- coding: utf-8 -*-

import dns.resolver
import dns.ipv6
import dns.ipv4
import os, sys, socket
import urllib2
import MySQLdb
from ConfigParser import SafeConfigParser
from optparse import OptionParser

CONFIG = '/etc/mysql-grants.conf'
HOSTNAME = socket.getfqdn()
CONDUCTOR_URL = 'http://c.yandex-team.ru/api'

def checkIP(host):
    try:
       if dns.ipv4.inet_aton(host): return True
    except Exception as err:
       try:
           if dns.ipv6.inet_aton(host): return True
       except Exception as err:
           return False

def dnsRequest(*hostnames):
    ''' Принимает значение имени хоста и  выводит IPv4 & IPv6
        адреса машин.
    '''
    result = list()
    for host in hostnames:
        if debug: print '[func(dnsRequest)]', host
        if checkIP(host): 
            result.append(host)
        else:
            for type in ['A', 'AAAA']:
                try:
                    answer = dns.resolver.query(host, type, raise_on_no_answer=False) 
                    for ip in answer:
                        if debug: print '[func(dnsRequest)]', ip
                        result.append(ip)
                except TypeError as err:
                    pass
                except dns.resolver.NXDOMAIN as err:
                    raise ValueError('1;DNS ERROR for host %s' % host)
    return result

def readConfig(config=CONFIG):
    ''' Принимает на вход путь до основного конфига mysql-grants.
        На выходе словарь с указанием directory пути и имени файла filename
    '''
    with open(CONFIG, 'r') as _file:
        content = _file.readlines()
        content = [ i.strip().replace(' ', '') for i in content ] 
    result = dict()
    def searchParam(*search):
        for param in search:
            if string.startswith(param):
                result[param] = string.split('=')[1]
    for string in content:
        searchParam('directory', 'filename')
    return result

def getConductorGroups(group, address=CONDUCTOR_URL, method='groups2hosts'):
    ''' Ходит с кондуктор за списком машин. На вход принимает кондукторную группу.
        На выходе получаем ipv4 & ipv6 адреса машин.
    '''
    group = group.strip('%')
    rs = os.path.join(address, method, group)
    if debug: print '[func(getConductorGroups)]', group 
    try:
        request = urllib2.urlopen(rs, timeout=5)
        result = request.read().rstrip('\n').split('\n')
        if not result: raise ValueError('1;Conductor group %s are empty!' % group)
    except urllib2.HTTPError as err:
        if err.code == 404: raise ValueError('1;Not found cgroup %s' % group)
        raise
    except Exception as err:
        raise ValueError('0;Conductor not working: %s' % str(err))
    return dnsRequest(*result)

def mysqlConnect(mysql_configs, server_hosts, server_users):
    ''' Проверяем соостветствие user@host в базе. На вход принимает путь до файла
        my.cnf, словарь группа_серверов@список_ip_адресов, группу списков 
        пользователь_mysql@группа_серверов. 
        ['/etc/mysql/ppcordstat.cnf', '/etc/mysql/ppclog.cnf']
        {'soaps': [<DNS IN A rdata: 93.158.132.139>, <DNS IN A rdata: 141.8.173.11>]},
        [('root', 'localhost'), ('adiuser', 'frontends')]
        На выходе выводит сообщение в stdout.
    '''
    def requestMysql():
        request = "SELECT user, host FROM mysql.user \
                                   WHERE user='%s' AND host='%s'" % (user, host)
        cursor.execute(request)
        result = cursor.fetchall()
        if result: return True
    for config in mysql_configs:
        if not os.path.exists(config): continue
        if debug: print 'Read mysql config: %s' % config
        try:
            myconnect = MySQLdb.connect(read_default_file=config)
        except Exception as err:
            raise ValueError('1;Mysql %s error: %s' % (config, str(err)))
        cursor = myconnect.cursor()
        for user, group in server_users:
            for host in server_hosts[group]:
                if not requestMysql():
                   host = str(host).replace('::', ':0:')
                   if not requestMysql():
                       raise ValueError( '1;Mysql %s has broken grants for %s@%s' % (config, user, host) )

def parseConfig(params):
    ''' Парсим конфиг грантов БД. Путь берется из конфига mysql-grants.
    ''' 
    config_list = [ _name for _name in os.listdir(params['directory']) if not _name.startswith('.') and 
                                                                          not _name.endswith('.yaml') ]
    for _config in config_list:
        parser = SafeConfigParser(allow_no_value=True)
        if debug: print 'Read config grants %s' % _config
        parser.read(os.path.join(params['directory'], _config))
        mysql_configs = [ i[0] for i in parser.items('configs') ]

        server_hosts = dict([ (i[0].split()[0], i[0].split()[1]) 
                              for i in parser.items('hosts') ])
        server_users = [ (i[0].split()[0].split('@')[0], i[0].split()[0].split('@')[1]) 
                              for i in parser.items('grants') ]

        for group in server_hosts: 
            if server_hosts[group].startswith('%') and len(server_hosts[group].expandtabs().rstrip())>1:
                server_hosts[group] = getConductorGroups(server_hosts[group])
            elif server_hosts[group].startswith('%'):
                server_hosts[group] = ['%',]
            elif server_hosts[group].count('localhost'):
                server_hosts[group] = ['localhost',]
            else:
                server_hosts[group] = dnsRequest(server_hosts[group])
        if debug: print mysql_configs, server_hosts, server_users  
        yield mysql_configs, server_hosts, server_users
    
if __name__ == '__main__':

    parser = OptionParser()
    parser.add_option("--debug", "-d", dest="debug", help="enable debug messages", action="store_true")
    (options, args) = parser.parse_args()

    debug = True if options.debug else False 

    try:
        for mysql_grants  in  parseConfig(readConfig()):
            mysqlConnect(*mysql_grants)
    except Exception as err:
        if debug: raise
        print str(err)
        sys.exit(1)
    print '0;Grants OK'
