#!/bin/sh

# ppcbackup
# /usr/local/bin/git-partner_backup_rotate.sh
# cron line: 0 7 * * * root [ -x /usr/local/bin/git-partner_backup_rotate.sh ] && /usr/local/bin/git-partner_backup_rotate.sh

DATE=`date +%F`
TWO_DA="`date +%F -d '2 days ago'`"
BACKUP_DIR="/local/backup/zfsbackups/git-partner" # no slash at the end
GIT_PARTNER_BACKUP_ERR="0"
SHORT_POOL_NAME="git-partner"

# chk backup
# size
for i in `du -s "$BACKUP_DIR"/* | awk '{print $1}'`; do
    test $i -le 716800 && GIT_PARTNER_BACKUP_ERR="1" && echo "`ls -1sSr "$BACKUP_DIR"/ | sed -n 2p`\n" | mail -s "check git backup archive size (less than 700mb)" partner-cron@yandex-team.ru
    test $i -ge 2097152 && GIT_PARTNER_BACKUP_ERR="1"&& echo "`ls -1sS "$BACKUP_DIR"/ | sed -n 2p`\n" | mail -s "check git backup archive size (more than 2gb)" partner-cron@yandex-team.ru
done

# number of files
test `ls -1 "$BACKUP_DIR"/"$SHORT_POOL_NAME"@????-??-??.gz | wc -l` -ne 3 && GIT_PARTNER_BACKUP_ERR="1" && echo "check number of __DAILY__ git-partner archives\n" | mail -s "git-partner daily backup count err" partner-cron@yandex-team.ru
test `ls -1 "$BACKUP_DIR"/"$SHORT_POOL_NAME"@week_num_??.gz | wc -l` -ne 1 && GIT_PARTNER_BACKUP_ERR="1" && echo "check number of __WEEKLY__ git-partner archives\n" | mail -s "git-partner weekly backup count err" partner-cron@yandex-team.ru

test "$GIT_PARTNER_BACKUP_ERR" -eq 1 && exit 1

# rm old archive
rm "$BACKUP_DIR"/git-partner@"$TWO_DA".gz

# weekly
if [ "`date +%a`" = "Sun" ]; then
   rm "$BACKUP_DIR"/"$SHORT_POOL_NAME"@"week_num_`date +%U -d 'week ago'`".gz
   ln "$BACKUP_DIR"/"$SHORT_POOL_NAME"@"$DATE".gz "$BACKUP_DIR"/"$SHORT_POOL_NAME"@"week_num_`date +%U`".gz
fi

