#!/bin/sh

# ppcdev01g
# /usr/local/bin/git-partner_backup.sh
# cron line:0 3 * * * root [ -x /usr/local/bin/git-partner_backup.sh ] && /usr/local/bin/git-partner_backup.sh

DATE=`date +%F`
OLD_DATE=`date +%F -d '3 days ago'`
SHORT_POOL_NAME='git-partner'
PARENT_POOL_NAME='pool/openvz'			# NO SLASH AT THE END
SNAPSHOT_NAME="$PARENT_POOL_NAME/$SHORT_POOL_NAME@$DATE"
OLD_SNAPSHOT_NAME="$PARENT_POOL_NAME/$SHORT_POOL_NAME@$OLD_DATE"
SNAPSHOT_BUFFER="/pool/snapshot-buffer"
REMOTE_MODULE="ppcbackup.yandex.ru::zfsbackups/git-partner"

/sbin/zfs snapshot $SNAPSHOT_NAME &&
/sbin/zfs hold bkp $SNAPSHOT_NAME &&

/sbin/zfs send $SNAPSHOT_NAME | gzip > "$SNAPSHOT_BUFFER"/"$SHORT_POOL_NAME"@"$DATE".gz && # change archive type?
cd "$SNAPSHOT_BUFFER"
#rsync -PavX "$SNAPSHOT_BUFFER"/"$SHORT_POOL_NAME"@"$DATE".gz "$REMOTE_MODULE" &&
rsync -PavX "$SHORT_POOL_NAME"@"$DATE".gz "$REMOTE_MODULE" &&
/sbin/zfs release bkp $SNAPSHOT_NAME &&

/sbin/zfs destroy $OLD_SNAPSHOT_NAME &&
rm "$SNAPSHOT_BUFFER"/"$SHORT_POOL_NAME"@"$OLD_DATE".gz || echo -e "no useful information, you may find it on ppcdev01g\n" | mail -s "git-partner daily backup err (source: ppcdev01g)" dragomir@yandex-team.ru


