#!/usr/bin/python
# -*- coding: utf-8 -*-
# vim: set tabstop=4 shiftwidth=4 softtabstop=4 expandtab smartindent:

import urllib2 as urllib
import argparse
import xml.etree.ElementTree as ET
from random import uniform
import json
import re
import pickle
import datetime
import errno

import pywrr

FORWARD_API = "http://bot.yandex-team.ru/api/changeForward.php"
STAFF_API = "http://center-robot.yandex-team.ru/api/v2/staff.xml"
WHERE_API = "http://center-robot.yandex-team.ru/api/v1/user"
GAP_API = "http://gap-api.yandex-team.ru/api/gap/current.xml"
AVAILABLE_PATTERNS = (ur'телефонодоступен', ur'из\s+дома', ur'в\s+офисе')

class User(object):
    def __init__(self, login, weight = 10):
        self.login = login
        self.weight = weight
        self.at_office = at_office(self.login)
        self.available_by_phone = available_by_phone(self.login)
        self.work_phone = get_phone(self.login, 'mobile')
        self.gap = get_gap(login)

        if self.available_by_phone:
            return
        if not self.at_office:
            self.weight = 5
        if self.gap:
            self.weight = 0

    def __lt__(self, other):
        if self.weight == other.weight:
            return uniform(0, 1) < 0.5
        else: return self.weight < other.weight

    def __eq__(self, other):
        res = self.login == other.login and self.weight == other.weight and self.work_phone == other.work_phone
	return res

    def __str__(self):
        return "login: %s weight: %.2f at_office: %s work_phone: %d gap: %s available_by_phone: %s" % (self.login, self.weight, str(self.at_office), self.work_phone, str(self.gap), self.available_by_phone)

# helper functions
def change_forward(forward_to):
    url = "%s?num=%d&fnum=%d" % (FORWARD_API, args.forward_from_number, forward_to)
    return urllib.urlopen(url).read()

def get_current_forward():
    url = "%s?num=%d&getForward" % (FORWARD_API, args.forward_from_number)
    return int(urllib.urlopen(url).read())

def get_phone(login, phone_type='mobile'):
    url = "%s?fields=work_phone&token=%s&login__in=%s" % (STAFF_API, args.center_token, login)
    phone = ET.fromstring(urllib.urlopen(url).read())[0][0].text
    return int('55' + phone) if phone_type=='mobile' else int(phone)

def at_office(login):
    url = "%s/%s/where.json?token=%s" % (WHERE_API, login, args.center_token)
    r = json.loads(urllib.urlopen(url).read())[0]
    return (r["office__code"] != None and r["hours_ago"] == 0)

def get_gap(login):
    url = "%s?future_lookup=0&encoding=utf8&token=%s&login_list=%s" % (GAP_API, args.gap_token, login)
    # xmpparser fails here
    m = re.search(r'subject_id="(\S+)"', urllib.urlopen(url).read())
    if m:
        return m.group(1)
    return None

def available_by_phone(login):
    try:
        url = "http://xmpp.yandex-team.ru:8080/presence/xml?user=%s@yandex-team.ru" % (login,)
        s =  ''.join([ x.text for x in ET.fromstring(urllib.urlopen(url).read())[0] ])
        for p in AVAILABLE_PATTERNS:
            if re.search(p, s, re.UNICODE | re.IGNORECASE): return True
    except Exception as e:
        print "%s [warn] Can't get jabber status message: %s" % (datetime.datetime.now(), str(e))
        pass
    return None

def select_duty_random(users):
    # sort by weight desc
    users = sorted([u for u in users if u.weight > 0], reverse=True)
    assert(len(users))
    total_weight = sum(u.weight for u in users)
    # random fload t: 0 <= t < total_weight
    thresh = uniform(0, total_weight - 1)
    for user in users:
        thresh -= user.weight
        if thresh < 0.0:
            return user

def select_duty_wrr(users):
    # always start new scheduler from random user (sorted)
    users_state = [(u, int(round(u.weight))) for u in sorted(users) if u.weight > 0]
    users_state_old = None 
    try:
        with open(args.users_state, 'rb') as f: users_state_old = pickle.load(f)
    except IOError as e:
        if e.errno == errno.ENOENT: pass
        else: raise

    sched = pywrr.WRRScheduler(users_state)
    shed_old = None 
    try:
        with open(args.scheduler_state, 'rb') as f: sched_old = pickle.load(f)
    except IOError as e:
        if e.errno == errno.ENOENT: pass
        else: raise

    # restore old scheduler if state not changed
    users_changed = not (users_state_old and len(users_state) == len(users_state_old) and \
                         reduce(lambda v1,v2: v1 and v2, map(lambda v: v in users_state_old, users_state)))
    if not users_changed and sched_old: sched = sched_old

    next_user = sched.get_next()[0] 
    # remember current state
    with open(args.users_state, 'wb') as f: pickle.dump(users_state, f)
    with open(args.scheduler_state, 'wb') as f: pickle.dump(sched, f)
    return next_user

def select_duty(users, algo='wrr'):
    if algo == 'wrr': return select_duty_wrr(users)
    return select_duty_random(users)

# main
parser = argparse.ArgumentParser()
parser.add_argument("-c", "--center-token", type=str, required=True)
parser.add_argument("-g", "--gap-token", type=str, required=True)
parser.add_argument("-n", "--forward-from-number", type=int, required=True)
parser.add_argument("-l", "--forward-to-logins", type=str, required=True)
parser.add_argument("-s", "--scheduler-state", type=str, required=True)
parser.add_argument("-u", "--users-state", type=str, required=True)
args = parser.parse_args()

# fill up users info and calculate weights
users = [User(login) for login in args.forward_to_logins.split(",")]
#users = [User('civil', 3), User('guba', 10), User('frenz', 3), User('velom', 3)]
duty = select_duty(users)

res = change_forward(duty.work_phone)
print "%s changed to %s. All users: %s. Phone change handle output: %s" % (datetime.datetime.now(), str(duty), ",".join([str(u) for u in users]), str(res))
