#!/bin/bash

set -e
#set -x
#--command=start
#--orig_master_host=(orig master's hostname)
#--orig_master_ip=(orig master's ip address)
#--orig_master_port=(orig master's port number)
#--new_master_host=(new master's hostname)
#--new_master_ip=(new master's ip address)
#--new_master_port(new master's port number)
#--new_master_user=(new master's user)
#--new_master_password(new master's password)

set -- `getopt -q -l command: -l new_master_host: -l dbname: -l orig_master_host: "" "$@"`

while [ ! -z "$1" ]
echo $1 $2
do
  case "$1" in
    --dbname)		DBNAME=`echo $2 | sed "s/'//g"`		; shift 2;;
    --command)		COMMAND=`echo $2 | sed "s/'//g"`	; shift 2;;
    --new_master_host)	NEW_MASTER=`echo $2 | sed "s/'//g"`	; shift 2;;
    --orig_master_host)	OLD_MASTER=`echo $2 | sed "s/'//g"`	; shift 2;;

     *) break;;
  esac

done

if [ "x$COMMAND" = "xstop" ]; then
	echo "Close $DBNAME using: lfw $DBNAME -write"
	ssh $OLD_MASTER "lfw $DBNAME -write"
	echo "Done."
fi

if [ "x$COMMAND" = "xstart" ]; then
	echo "Open $DBNAME using: lfw $DBNAME +write"
	ssh $NEW_MASTER "lfw $DBNAME +write"
	echo "Done."
	echo "Update zk configuration."
	zk-db-config -c /etc/zk-delivery/gorynych.cfg -n /gorynych/20-databases.py.production -t external --external-checker /usr/bin/gorynych-dbconfig-checker.py --external-editor /usr/lib/yandex-gorynych-zk-db-config/gorynych-switch-zk-master.py
	echo "Done."
fi
exit 0

