#!/usr/bin/perl

%hosts;
%bad_hosts;

map { /^(\S+)/; $hosts{$1} = 1; } split /\n/, qx(jctl list checks | tail -n+4);

for (keys %hosts) {
  $resps = qx(curl -s "http://ro.admin.yandex-team.ru/api/get_host_resp.sbml?hostname=$_");
  $failed = ($? >> 8);
  chomp $resps;
  next if $resps =~ /\w+/;

  $golem = qx(jctl list checks -host $_ | grep GOLEM);
  next if ($? >> 8);
  $bad_hosts{$_} = $failed ? "can't get resps: $resps" : "no resps";
}
@bad_hosts = keys %bad_hosts;
if (scalar @bad_hosts) {
  print "1; " . join(',', @bad_hosts). "\n";
}
else {
  print "0;OK\n";
}

