#!/usr/bin/perl

=head1 Проверка методов Yandex::Antispam::RTChecker

    check_urls - получает на вход массив урлов и возвращает хэш с негативными резульитатами

=cut
use Direct::Modern;

use JSON;
use Test::More tests => 6;
use Test::HTTP::Server;

use Yandex::Antispam::RTChecker;

sub random_string{
    my @chrs = ('0' .. '9', 'a' .. 'z', 'A' .. 'Z', '_');
    return join('', map { $chrs[ rand(scalar(@chrs)) ] } (1..20))
}

sub random_answer{
    my $res = [];
    push @$res, random_string() for 0 .. rand(3);
    return $res;
}

sub generate_tests {
    my ($qnt) = @_;

    my $res = {};
    for(1 .. $qnt) {
        my $url = random_string();
        my $result = rand() < 0.8 ? 0 : random_answer();
        $res->{ $url } = $result;
    }
    return $res;
}

sub test{
    our ($test) = @_;

    sub _test{
        my ($self) = @_;
        my $urls = JSON::from_json($self->{'body'})->{'params'}{'urls'};

        my $res = [];
        for my $url (@$urls){
            if($test->{ $url->{'url'} }){
                push @$res, {%$url, 'verdicts' => $test->{ $url->{'url'} }}
            }
        }
        my $json = JSON::to_json({"jsonrpc" => "2.0", "id" => "0", "result" => $res});
        return $json;
    }

    {
        no warnings qw/redefine once/;
        *Test::HTTP::Server::Request::jsonrpc = \&_test;
    }
    my $server = Test::HTTP::Server->new();
    $Yandex::Antispam::RTChecker::API_URL = $server->uri.'jsonrpc/list';
    my $res = Yandex::Antispam::RTChecker->check_urls( [ keys %$test ] );
    # упорядочим вердикты для сравнения
    $res = {map { $_ => [sort @{ $res->{ $_ } }] } keys %{ $res }};
    # сгенерим ожидаемый ответ
    my $right_answer = {map { $_ => [sort @{ $test->{ $_ } }] } grep { $test->{ $_ } } keys %$test};
    is_deeply( $res, $right_answer, "unfold is ok" );
}

for my $qnt (0, 1, 100, 1001, 10000, 10500){
    test(generate_tests( $qnt ))
};

1;

__END__
