#!/usr/bin/perl

use common::sense;
use lib::abs '../lib';
use Yandex::Avatars::MDS;
use Yandex::Log;
use Path::Tiny;
use JSON;
use Carp;

$SIG{__WARN__} = \&Carp::cluck;
$SIG{__DIE__} = \&Carp::confess;

my $image_file = shift or die "usage: $0 <path/to/image>\n";

sub j
{
    print "".(to_json(\@_, { pretty => 1, canonical => 1 }))."\n";
}

$Yandex::Log::LOG_ROOT = lib::abs::path("..");
my $av = Yandex::Avatars::MDS->new(
    namespace => 'direct-picture',
    authorization => '',
    get_host => 'avatars.mdst.yandex.net',
    put_host => 'avatars-int.mdst.yandex.net:13000',
);

my $img = path($image_file);

my $name = $img->basename;

my $gid;
{
j my $res = $av->put($name, $img->slurp_raw);
j $gid = $res->{'group-id'};
}

{
j my $res = $av->put($name, $img->slurp_raw); 
j $gid = $res->{'group-id'};
}

j $av->couplelist;

my $image = $av->get($gid, $name, 'orig');
j 'image matches', $image eq $img->slurp_raw;

eval { j $av->get($gid, "the_404") }; j $@ if $@;

j [ getimageinfo => $av->getimageinfo($gid, $name) ];
j [ getinfo => $av->getinfo($gid, $name) ];

# j [ delete => $av->delete($gid, $name) ];
# eval { j $av->delete($gid, "404_this_".$name); }; j $@ if $@;

j $av->statistics();

