#!/usr/bin/perl

use strict;
use Test::More tests => 5;
use Test::Exception;

use Yandex::Avatars;

my $avatars = Yandex::Avatars->new(
    get_host  => 'avatars-fast.yandex.net:80',
    put_host  => 'avatars-int-bs.yandex.net:14000',
    namespace => 'direct',
);

ok($avatars->avatars_url('put') =~ /put-/, "avatars put");
ok($avatars->avatars_url('delete') =~ /delete-/, "avatars delete");
ok($avatars->avatars_url('get') =~ m!^http://.*/get-!, "avatars get (with proto and port)");
ok($avatars->avatars_url('get', short => 1) =~ m!^//!, "avatars get (short)");

dies_ok sub { $avatars->avatars_url('xxx') }, "die on invalid param";
