#!/usr/bin/perl -w

use strict;
use Data::Dumper;
use SOAP::Lite;
use Test::More tests => 2;
use Test::Deep;

use Yandex::Balance;

use utf8;
use open ':std' => ':utf8';

sub bp {
    my $str = shift;
    return Yandex::Balance::balance_parse_fault_xml($str);
}

cmp_deeply(bp("<error>
        <method>Balance.CreateRequest</method>
        <code>ORDER_NOT_FOUND</code>
        <parent-codes><code>NOT_FOUND</code><code>EXCEPTION</code></parent-codes>
        </error>"
           ), {
               'parent-codes' => [
                   'NOT_FOUND',
                   'EXCEPTION'
                   ],
               'method' => 'Balance.CreateRequest',
               'code' => 'ORDER_NOT_FOUND'
           }, 'multiparent');

cmp_deeply(bp("<error>
        <code>ORDER_NOT_FOUND</code>
        <parent-codes><code>NOT_FOUND</code></parent-codes>
        </error>"
           ), {
               'parent-codes' => [
                   'NOT_FOUND',
                   ],
               'code' => 'ORDER_NOT_FOUND'
           }, 'one-parent');
