package Yandex::BMApi;

# $Id$

# ABSTRACT: bmapi.yandex.ru client library

=head1 SYNOPSIS

    my $api = Yandex::BMApi->new();

    my $phrases = [ $phrase1, $phrase2, ... ];

    # unified method call
    my $phrases_filteded = $api->call(get_wide_filtered => $phrases);

    # mapped method call
    my $phrases_with_minus_words = $api->add_search_categs_minuswords($phrases);


=head1 DESCRIPTION

Библиотека для обращения к сервису bmapi.yandex.ru

https://wiki.yandex-team.ru/BM/InterfejjsBM

=cut


use 5.010;
use strict;
use warnings;
use utf8;

use Carp;
use Encode;
use Yandex::HTTP qw/http_fetch/;
use Yandex::Trace;

use Log::Any '$log';

use Mouse;

#our $URL ||= 'http://bmapi-dev01e.yandex.ru/fcgi-bin/';
our $URL ||= 'http://bmapi.yandex.ru/fcgi-bin/';
our $HTTP_OPTIONS ||= {
    timeout => 7,
    connect_timeout => 1,
    num_attempts => 2,
    soft_timeout => 2,
};

=attr api_url

=attr api_timeout

=attr ua

=cut

has url => ( is => 'ro', required => 1, default => sub { $URL } );
has http_options => ( is => 'ro', required => 1, default => sub { $HTTP_OPTIONS } );

=method call

    my $processed_phrases = $api->call($method => \@original_phrases);

Unified BM API call. Base for all mapped methods.

Returns list of phrases.

=cut

sub call {
    my ($self, $action, $data, %extra_arg) = @_;

    my $payload = [
        act => "$action",
        data => $self->_encode_request_data($data),
        %extra_arg,
    ];

    if ($log->is_trace) {
        require JSON;
        $log->trace("Call: " . JSON::to_json($payload));
    }

    my $profile = Yandex::Trace::new_profile("bm:api:$action");
    my $content = http_fetch(POST => $self->url, $payload,
                             headers => {
                                 'Content-Type' => 'application/x-www-form-urlencoded',
                             },
                             %{$self->http_options},
        );
    undef $profile;

    $log->trace("Response: $content")  if $log->is_trace;

    return $self->_decode_response($content);
}


sub _encode_request_data {
    my ($self, $data) = @_;

    return $data if !ref $data;

    croak "Bad data type: " . ref $data  if ref $data ne 'ARRAY';

    my $encoded = join "\n", @$data, "#END";
    return $encoded;
}


sub _decode_response {
    my ($self, $data) = @_;

    my @phrases = grep {!/^\#/x} split /\n/x, $data;

    return \@phrases;
}


=method add_search_categs_minuswords

=method add_search_categs_minuswords_without_cache

=method add_search_porn_minuswords

=method get_qtail_minus_phrases

=cut


our @METHODS_TO_MAP = qw/
    add_search_categs_minuswords
    add_search_categs_minuswords_without_cache
    add_search_porn_minuswords
    get_qtail_minus_phrases
    minus_words_pack
    minuswords_for_banner
    pack_minuswords
/;

for my $method (@METHODS_TO_MAP) {
    my $sub = sub {
        my $self = shift;
        return $self->call( $method => @_);
    };
    __PACKAGE__->meta->add_method($method => $sub);
}

__PACKAGE__->meta()->make_immutable();
1;

