package Yandex::BMLightAdvq;

# $Id$

# ABSTRACT: client module for bmlight-advq.yandex.ru

=head1 SYNOPSIS

    my @phrases = (
        $phrase1,
        [ $phrase2, $region_id ],
        ...
    );
    my $forecast = Yandex::BMLightAdvq::bm_light_advq_call(\@phrases);
    if ($forecast->{$phrase1} > $threshold ) {
        ...

=head1 DESCRIPTION

Библиотека для запросов к "лёгкому ADVQ", он же "быстрый ADVQ"
bmlight-advq.yandex.ru (разработка Группы исследований рекламных технологий).

Сервис выдаёт прогноз показов для ключевых слов, общий и по регионам.
Точность хуже, чем у обычного ADVQ, но работает значительно быстрее.

=cut

use 5.010;
use strict;
use warnings;
use utf8;

use Carp;
use Encode;
use Yandex::HTTP qw/http_fetch/;
use Yandex::Trace;

use Log::Any '$log';



our $BM_LIGHT_ADVQ_URL ||= 'http://bmlight-advq.yandex.ru:20303/';
our $HTTP_OPTIONS ||= {
    timeout => 7,
    connect_timeout => 1,
    num_attempts => 2,
    soft_timeout => 2,
};


=head2 bm_light_advq_call

    my $results = Yandex::BMLightAdvq::bm_light_advq_call(\@phrases);

Вызов апи bmlight-advq.

На входе:
массив фраз:
  * "фраза"
  * [ "фраза", $geo_id ]

На выходе:
хеш вида { фраза => прогноз }

=cut



sub bm_light_advq_call
{
    my ($phrases) = @_;

    my $payload = encode utf8 => join "\n",
        map {join "\t", map {_filtered_phrase($_)} (ref $_ ? @$_ : $_)}
        @$phrases;

    $log->trace("Call: $payload")  if $log->is_trace();
    my $profile = Yandex::Trace::new_profile("bm:light_advq");
    my $content = http_fetch(POST => $BM_LIGHT_ADVQ_URL, $payload, %$HTTP_OPTIONS);
    undef $profile;
    $log->trace("Response: $content")  if $log->is_trace();

    my %result =
        map {(split m{\t})}
        split m{\n}, $content, -1;

    return \%result;
}


sub _filtered_phrase
{
    my ($phrase) = @_;
    $phrase =~ s/[\t\n]/ /g;
    return $phrase;
}



1;
