package Yandex::BMWordstat;

# $Id$

# ABSTRACT: bmwordstat.yandex.ru client library

=head1 SYNOPSIS

    my @req = (
        $phrase1,
        [ $phrase2, $num_results, $filter_adult ],
        ...
    );
    my $results = Yandex::BMWordstat::bm_wordstat_call(\@req);

=head1 DESCRIPTION

Библиотека для обращения к сервису bmwordstat.yandex.ru

Сервис по списку ключевых фраз выдаёт для каждой из них "подсказки" -
фразы, которые он считает близкими и релевантными.

=cut


use 5.010;
use strict;
use warnings;
use utf8;

use Carp;
use Encode;
use Yandex::HTTP qw/http_fetch/;
use Yandex::Trace;

use Log::Any '$log';



our $URL ||= 'http://bmwordstat-rt.yandex.net:80/';
our $HTTP_OPTIONS ||= {
    timeout => 7,
    connect_timeout => 1,
    num_attempts => 2,
    soft_timeout => 2,
};

our $DEFAULT_NUM_RESULTS ||= 10;




=head2 bm_wordstat_call

    my @req = (
        $phrase1,
        [ $phrase2, $num_results, $filter_adult ],
        ...
    );
    my $results = Yandex::BMWordstat::bm_wordstat_call(\@req);

Вызов апи bmwordstat.

На входе:
массив фраз. Каждая фраза - скаляр или массив формата [ фраза, количество_подсказок, флаг_порно ].

На выходе:
массив, порядок и размер соответствуют запрошенным фразам.
Каждый элемент - массив подсказок по фразе [ [ фраза => коэффициент_близости ], ... ]

=cut

sub bm_wordstat_call
{
    my ($req_data) = @_;

    my $payload = encode utf8 => join "\n", map {
        my ($phrase, $num, $filter_adult) = ref $_ ? @$_ : ($_);
        $phrase =~ s/[\t\n]/ /gxms;
        $num ||= $DEFAULT_NUM_RESULTS;
        join "\t", $phrase, 0+$num, 0+!!$filter_adult;
    } @$req_data;

    $log->trace("Call: $payload")  if $log->is_trace();
    my $profile = Yandex::Trace::new_profile('bm:wordstat');
    my $content = http_fetch(POST => $URL, $payload, %$HTTP_OPTIONS);
    undef $profile;
    $log->trace("Response: $content")  if $log->is_trace();

    my @results =
        map {[map {[split /\s+(?=[\d\.]+$)/]} split /\s+,\s+/]}
        split m{/}, $content, -1;

    return \@results;
}



1;
