package Yandex::BSInfo;

=pod
    $Id$
    вызовы различныз bs.yandex.ru/page/...
=cut

use strict;
use warnings;

use POSIX qw/strftime/;
use HTTP::Request;
use LWP::UserAgent;

use base qw/Exporter/;

our @EXPORT = qw/
    bsinfo_orders_status_active
    /;

our $DEBUG = 0;
our $TIMEOUT = 10;
our $RETRIES = 2;

our $ORDERS_STATUS_URL ||= 'http://yabs.yandex.ru/ordstat';

# получить информацию, включены ли сейчас заказы в БК
sub bsinfo_orders_status_active {
    my ($orders_arr) = shift;
    my @orders = grep {/^\d+$/} @$orders_arr;

    my %RET;
    my $ua = new LWP::UserAgent(timeout => $TIMEOUT);
    # нарезаем массив id на части
    while(my @chunk = splice(@orders, 0, 1000)) {
        my $url = $ORDERS_STATUS_URL."?order-id=".join("%0A", @chunk);

        my $req = new HTTP::Request(GET => $url);
        _debug("bsinfo_orders_status - request:", $req->as_string);
        my $resp;
        # пытаемся сделать несколько запросов
        for my $try (1..$RETRIES) {
            $resp = $ua->request($req);
            _debug("bsinfo_orders_status try $try - response:", $resp->as_string);
            last if $resp->is_success;
        }
        die "Incorrect bs response: ".$resp->status_line if !$resp->is_success;
        # парсим ответ
        for my $line (split /\n/, $resp->content) {
            if ($line =~ /^(\d+)\t(0|1)/) {
                $RET{$1} = $2 ? 0 : 1;
            } else {
                die "Incorrect line format '$line'";
            }
        }
    }

    return \%RET;
}

# вывести строки дебага
sub _debug {
    return if !$DEBUG;
    my $time = strftime("%Y-%m-%d:%H:%M:%S", localtime);
    for my $line (grep {!/^\s*$/} map {split /\n/, $_} @_) {
        print STDERR "$time\t$$\tYandex::BSInfo\t$line\n";
    }
}

1;
