package Yandex::BSTools;

=pod
    $Id$
    Работа с классификатором БК
=cut

use strict;
use warnings;

use Yandex::Trace;
use IO::Socket::IP;
use Encode;

use base qw/Exporter/;

our @EXPORT = qw/
    bstools_classify
    bstools_classify_packet
    /;

our $CLASSIFY_HOST ||= 'bsqueryclassify.yandex.ru:3301';
our $TIMEOUT ||= 10;

# по массиву фраз получить набор рубрик для каждой фразы
sub bstools_classify {
    my ($phrases, $opts) = @_;
    my $profile = Yandex::Trace::new_profile('bstools:classify');

    # устанавливаем таймаут
    my $timeout = exists $opts->{timeout} ? $opts->{timeout} : $TIMEOUT;
    local $SIG{ALRM} = sub {
        die "BSTools classify timeout exceeded."
            ." Timeout = $timeout."
            ." Classifier: $CLASSIFY_HOST."
            ." Phrases(".(scalar @{$phrases || []})."): "
                    .join(',', map {$_->{phrase}} @{$phrases||[]})
    };
    
    alarm($timeout);
    
    # соединяемся с классификатором
    my $sock = IO::Socket::IP->new($CLASSIFY_HOST) or die "Can't create socket: $!";
    binmode $sock, ":raw";
    syswrite($sock, "servant03");

    # цикл по всем фразам
    foreach my $ph (@{$phrases}) {
        my $profile = Yandex::Trace::new_profile('bstools:classify', tags => 'phrase');
        
        $ph->{bs_categories} = [];
        # посылаем запрос
        my $cmd = Encode::encode_utf8("class ".$ph->{phrase});
        syswrite($sock, sprintf("%07x%s", length($cmd), $cmd) );

        # разбираем ответ
        my $res_len_hex;
        sysread($sock, $res_len_hex, 7);
        my $res;
        sysread($sock, $res, hex($res_len_hex));
        my ($nums, $ret_phrase, @categories) = split /\t/, $res;

        # проверка результата
        if (!defined $ret_phrase) {
            warn "Strange result of bs classifier for '$ph->{phrase}': '$res'";
            next;
        }

        # разбираем категории
        for my $cat (@categories) {
            my ($cat, $relevance) = split /\s+/, $cat;
            push @{$ph->{bs_categories}}, {category_id => $cat, relevance => $relevance/1e6};
        }
    }
    alarm 0;
    return $phrases;
}

1;
